/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreElementPlayer;
import com.softsynth.score.ScoreList;

public class Sequence
extends ScoreList {
    @Override
    public ScoreElementPlayer start(ScoreElementPlayer parentPlayer, double time) {
        SequencePlayer player = new SequencePlayer(this, parentPlayer);
        player.startNext(time);
        return player;
    }

    @Override
    public String toString() {
        String text = "{ ";
        for (ScoreElement element : this.getElements()) {
            text = String.valueOf(text) + element + ", ";
        }
        text = String.valueOf(text) + "}";
        return text;
    }

    private static class SequencePlayer
    extends ScoreElementPlayer {
        Sequence sequence;
        private int cursor;
        private double nextTime;
        private boolean done;
        private ScoreElementPlayer currentPlayer;

        private SequencePlayer(Sequence sequence, ScoreElementPlayer parentPlayer) {
            super(sequence, parentPlayer);
            this.sequence = sequence;
            this.done = false;
        }

        private void startNext(double time) {
            this.nextTime = time;
            if (this.cursor < this.sequence.size()) {
                ScoreElement element = this.sequence.getElements().get(this.cursor);
                this.currentPlayer = element.start(this, time);
                this.done = this.currentPlayer.isDone();
            } else {
                this.done = true;
            }
        }

        @Override
        public double advance(double time) {
            if (time >= this.nextTime && this.currentPlayer != null) {
                this.nextTime = this.currentPlayer.advance(this.nextTime);
                if (this.currentPlayer.isDone()) {
                    ++this.cursor;
                    this.startNext(this.nextTime);
                }
            }
            return this.nextTime;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }
}

