/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PatchBox;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.gui.patch.TopPatchEditor;
import com.syntona.model.core.CoreBundle;
import com.syntona.model.core.PatchModule;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.PatchListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class PatchEditor
extends JPanel {
    private JToolBar toolbar;
    private EngineController engine;
    private PatchBox patchBox;
    PatchModule patchModule;
    PatchModulePresenter patchModulePresenter;
    private TopPatchEditor topPatchEditor;
    private ButtonGroup modeGroup = new ButtonGroup();
    private PatchListener patchListener;

    public PatchEditor(EngineController engine, TopPatchEditor topPatchEditor, PatchModulePresenter patchModulePresenter, PatchFrame patchFrame) {
        this.engine = engine;
        this.topPatchEditor = topPatchEditor;
        this.patchModulePresenter = patchModulePresenter;
        this.patchListener = new PatchListener(){

            @Override
            public void patchChanged(PatchModule patchModule) {
                PatchEditor.this.invokeRebuild();
            }
        };
        patchModulePresenter.getPatchModule().addPatchListener(this.patchListener);
        this.toolbar = new JToolBar();
        this.patchBox = new PatchBox(patchModulePresenter, patchFrame);
        this.setLayout(new BorderLayout());
        this.addTestTools();
        this.add((Component)this.toolbar, "North");
        JScrollPane scrollPane = new JScrollPane(this.patchBox);
        this.add((Component)scrollPane, "Center");
        this.patchBox.setLayout(null);
        this.rebuild();
    }

    private void addTestTools() {
        JButton addPatchButton = new JButton("Add Patch");
        this.toolbar.add(addPatchButton);
        addPatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchEditor.this.engine.sendAddModule(CoreBundle.getInstance(), PatchEditor.this.patchModulePresenter, "patch");
            }
        });
        JButton addVoiceButton = new JButton("Add Voice");
        this.toolbar.add(addVoiceButton);
        addVoiceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchEditor.this.engine.sendAddModule(JSynBundle.getInstance(), PatchEditor.this.patchModulePresenter, "voice");
            }
        });
        if (this.patchModulePresenter.getParent() != null) {
            this.toolbar.add(this.createParentPicker());
        }
        this.patchModulePresenter.addCustomTools(this.toolbar);
    }

    private Component createParentPicker() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("Parents:"));
        ArrayList<String> parents = new ArrayList<String>();
        PatchModulePresenter parent = this.patchModulePresenter.getParent();
        while (parent != null) {
            parents.add(parent.getName());
            parent = parent.getParent();
        }
        final JComboBox<String> petList = new JComboBox<String>(parents.toArray(new String[0]));
        petList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                PatchModulePresenter parent = PatchEditor.this.patchModulePresenter.getParent();
                while (parent != null && i < petList.getSelectedIndex()) {
                    parent = parent.getParent();
                    ++i;
                }
                if (parent != null) {
                    parent.showMainEditor();
                }
            }
        });
        panel.add(petList);
        return panel;
    }

    private void addModeButton(String text, final int buttonMode) {
        JRadioButton checkBox = new JRadioButton(text);
        this.modeGroup.add(checkBox);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchEditor.this.patchBox.setMode(buttonMode);
            }
        });
        this.toolbar.add(checkBox);
    }

    void invokeRebuild() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PatchEditor.this.rebuild();
            }
        });
    }

    private void rebuild() {
        this.removeAllUnits();
        ModulePresenter[] modulePresenterArray = this.patchModulePresenter.getPresenters();
        int n = modulePresenterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModulePresenter presenter = modulePresenterArray[n2];
            this.addModulePresenter(presenter);
            ++n2;
        }
        this.patchBox.refreshDisplay();
        this.repaint();
    }

    private void removeAllUnits() {
        this.patchBox.removeAll();
    }

    void addModulePresenter(ModulePresenter presenter) {
        ModuleView moduleView = presenter.getView();
        moduleView.setup(this, this.engine);
        this.patchBox.addModule(moduleView);
    }

    public void removeModulePresenter(ModulePresenter presenter) {
        ModuleView moduleView = presenter.getView();
        this.patchBox.removeModule(moduleView);
    }

    public TopPatchEditor getTopPatchEditor() {
        return this.topPatchEditor;
    }

    public PatchBox getPatchBox() {
        return this.patchBox;
    }

    public void deselectAll() {
        this.patchBox.deselectAll();
    }
}

