/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.syntona.model.SyntonaEngine;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.core.CoreBundle;
import com.syntona.model.core.PatchModule;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.Bundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;

public class TestSaveLoad
extends TestCase {
    private SyntonaEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.engine = SyntonaEngine.getInstance();
        this.engine.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.engine.stop();
        super.tearDown();
    }

    public void testSimplePatch() {
        try {
            PatchModulePresenter topPatch = this.engine.getTopPatches()[0];
            PatchModule topPatchModule = topPatch.getPatchModule();
            topPatchModule.clear();
            this.drainCommandQueue(200L);
            TestSaveLoad.assertEquals("Start empty", 0, topPatchModule.size());
            this.setupSimplePatch(topPatch);
            this.checkSimplePatch(topPatch);
            ByteArrayOutputStream outByteStream = this.savePatch(topPatch);
            this.checkSimplePatch(topPatch);
            topPatchModule.clear();
            TestSaveLoad.assertEquals("Start empty", 0, topPatchModule.size());
            byte[] bytes = outByteStream.toByteArray();
            String xmlText = new String(bytes);
            System.out.println("XML = " + xmlText);
            ByteArrayInputStream inByteStream = new ByteArrayInputStream(bytes);
            this.loadPatch(inByteStream, topPatch);
            this.checkSimplePatch(topPatch);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private void checkSimplePatch(PatchModulePresenter topPatch) {
        TestSaveLoad.assertEquals("Patch size ", 2, topPatch.getPatchModule().size());
    }

    private void loadPatch(ByteArrayInputStream inByteStream, PatchModulePresenter topPatch) {
        try {
            SyntonaLoader loader = topPatch.createSyntonaLoader();
            loader.parse(inByteStream);
            topPatch.loadTopPatch(loader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.drainCommandQueue(200L);
    }

    private ByteArrayOutputStream savePatch(PatchModulePresenter presenter) throws ParserConfigurationException {
        SyntonaSaver saver = presenter.createSyntonaSaver();
        presenter.saveTop(saver);
        saver.print();
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(outByteStream);
        saver.render(streamResult);
        return outByteStream;
    }

    private void setupSimplePatch(PatchModulePresenter topPatch) {
        Bundle basic = CoreBundle.getInstance();
        this.engine.sendAddModule(basic, topPatch, "+");
        this.engine.sendAddModule(basic, topPatch, "kick");
        this.drainCommandQueue(200L);
    }

    private void drainCommandQueue(long msec) {
        long timeout = -1L;
        try {
            timeout = this.engine.drainCommandQueue(msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestSaveLoad.assertTrue("Check drain timeout = " + timeout, timeout > 0L);
    }
}

