/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.softsynth.math.AudioMath;
import com.softsynth.math.JustRatio;
import com.softsynth.math.PrimeFactors;
import com.softsynth.score.ScoreNote;
import com.syntona.model.music.Intonation;

public class DynamicNote
extends ScoreNote {
    private double frequency = 440.0;
    private double time = 0.0;
    private double onTime = 0.5;
    private DynamicNote basis = null;
    private int numerator = 1;
    private int denominator = 1;
    private boolean dirty = true;
    private boolean recursing;
    private PrimeFactors primeFactors;
    private PrimeFactors primeFactorsTally;

    public DynamicNote(double frequency) {
        super(1.0);
        this.frequency = frequency;
    }

    public DynamicNote(DynamicNote note, int numerator, int denominator) {
        super(1.0);
        this.numerator = numerator;
        this.denominator = denominator;
        this.basis = note;
        this.markDirty();
        this.updateFrequency();
    }

    public DynamicNote(DynamicNote note) {
        super(1.0);
        this.basis = note;
        this.updateFrequency();
    }

    public void markDirty() {
        this.setDirty(true);
    }

    @Deprecated
    public void setDirty(boolean dirty) {
        if (dirty) {
            this.primeFactors = null;
            this.primeFactorsTally = null;
        }
        this.dirty = dirty;
    }

    public double getPitch() {
        return AudioMath.frequencyToPitch(this.getFrequency());
    }

    public void setPitch(double pitch) {
        this.frequency = AudioMath.pitchToFrequency(pitch);
    }

    public double getFrequency() {
        if (this.dirty) {
            this.updateFrequency();
        }
        return this.frequency;
    }

    private void updateFrequency() {
        if (this.recursing) {
            this.basis = null;
        }
        if (this.basis != null) {
            this.recursing = true;
            this.frequency = this.basis.getFrequency() * (double)this.numerator / (double)this.denominator;
            this.recursing = false;
        }
        this.dirty = false;
    }

    public DynamicNote getBasis() {
        return this.basis;
    }

    public void setBasis(DynamicNote basis) {
        this.basis = basis;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public double getOnTime() {
        return this.onTime;
    }

    public void setOnTime(double onTime) {
        this.onTime = onTime;
    }

    public void quantize() {
        this.quantizePitch();
        this.quantizeTime();
    }

    public void quantizeTime() {
        int quarters = (int)Math.round(this.getTime() * 4.0);
        this.setTime((double)quarters * 0.25);
    }

    public void quantizePitch() {
        if (this.basis == null) {
            int semitone = (int)Math.round(this.getPitch());
            this.setPitch(semitone);
        } else {
            double ratio = this.getFrequency() / this.basis.getFrequency();
            JustRatio justRatio = Intonation.getInstance().createJustRatio(ratio);
            ratio = justRatio.getValue();
            this.numerator = (int)justRatio.numerator;
            this.denominator = (int)justRatio.denominator;
            this.updateFrequency();
            this.markDirty();
        }
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
        this.markDirty();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
        this.markDirty();
    }

    public int compareTo(DynamicNote other) {
        double t1 = this.getTime();
        double t2 = other.getTime();
        return Double.compare(t1, t2);
    }

    @Override
    public String toString() {
        return "DynamicNote: " + this.numerator + "/" + this.denominator + " at T=" + this.getTime();
    }

    public PrimeFactors getPrimeFactors() {
        if (this.primeFactors == null) {
            this.primeFactors = new PrimeFactors(this.numerator, this.denominator);
        }
        return this.primeFactors;
    }

    public PrimeFactors getPrimeFactorsTally() {
        if (this.primeFactorsTally == null) {
            if (this.basis == null) {
                this.primeFactorsTally = this.getPrimeFactors();
            } else {
                PrimeFactors parentsTally = this.basis.getPrimeFactorsTally();
                this.primeFactorsTally = parentsTally.add(this.getPrimeFactors());
            }
        }
        return this.primeFactorsTally;
    }
}

