/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.EdgeDetector;
import com.jsyn.unitgen.EnvelopeDAHDSR;
import com.jsyn.unitgen.FilterLowPass;
import com.jsyn.unitgen.Latch;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.PulseOscillator;
import com.jsyn.unitgen.SawtoothOscillatorDPW;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.UnitSource;

public class SampleHoldNoteBlaster
extends Circuit
implements UnitSource {
    public UnitInputPort frequency;
    public UnitInputPort amplitude;
    public UnitInputPort modRate;
    public UnitInputPort modDepth;
    private UnitInputPort cutoff;
    private UnitInputPort resonance;
    private UnitInputPort pulseRate;
    private UnitInputPort sweepRate;
    private UnitInputPort sweepDepth;
    public UnitOutputPort output;
    private static SampleHoldNoteBlaster soundMaker;
    private UnitOscillator osc;
    private UnitOscillator samplee;
    private PulseOscillator pulser;
    private Latch latch;
    private UnitOscillator lfo;
    private FilterLowPass filter;
    private PassThrough frequencyPin = new PassThrough();
    private Multiply modScaler;
    private EnvelopeDAHDSR ampEnv;
    private Multiply sweepScaler;
    private EdgeDetector edgeDetector;
    private UnitInputPort pulseWidth;
    private UnitInputPort attack;
    private UnitInputPort decay;
    private UnitInputPort sustain;
    private UnitInputPort release;

    public static SampleHoldNoteBlaster getInstance() {
        if (soundMaker == null) {
            soundMaker = new SampleHoldNoteBlaster();
        }
        return soundMaker;
    }

    public SampleHoldNoteBlaster() {
        this.add(this.frequencyPin);
        this.modScaler = new Multiply();
        this.add(this.modScaler);
        this.sweepScaler = new Multiply();
        this.add(this.sweepScaler);
        this.edgeDetector = new EdgeDetector();
        this.add(this.edgeDetector);
        this.latch = new Latch();
        this.add(this.latch);
        this.samplee = new SineOscillator();
        this.add(this.samplee);
        this.pulser = new PulseOscillator();
        this.add(this.pulser);
        this.lfo = new SineOscillator();
        this.add(this.lfo);
        this.osc = new SawtoothOscillatorDPW();
        this.add(this.osc);
        this.filter = new FilterLowPass();
        this.add(this.filter);
        this.ampEnv = new EnvelopeDAHDSR();
        this.add(this.ampEnv);
        this.samplee.output.connect(this.latch.input);
        this.pulser.output.connect(this.edgeDetector.input);
        this.edgeDetector.output.connect(this.latch.gate);
        this.latch.output.connect(this.osc.frequency);
        this.frequencyPin.output.connect(this.osc.frequency);
        this.frequencyPin.output.connect(this.modScaler.inputA);
        this.modScaler.output.connect(this.lfo.amplitude);
        this.frequencyPin.output.connect(this.sweepScaler.inputA);
        this.sweepScaler.output.connect(this.samplee.amplitude);
        this.lfo.output.connect(this.osc.frequency);
        this.osc.output.connect(this.filter.input);
        this.filter.output.connect(this.ampEnv.amplitude);
        this.pulser.output.connect(this.ampEnv.input);
        this.amplitude = this.osc.amplitude;
        this.addPort(this.amplitude, "amplitude");
        this.amplitude.set(0.6);
        this.frequency = this.frequencyPin.input;
        this.addPort(this.frequency, "frequency");
        this.frequency.setup(50.0, 800.0, 2000.0);
        this.modRate = this.lfo.frequency;
        this.addPort(this.modRate, "modRate");
        this.modRate.setup(0.0, 12.0, 20.0);
        this.modDepth = this.modScaler.inputB;
        this.addPort(this.modDepth, "modDepth");
        this.modDepth.setup(0.0, 0.0, 0.5);
        this.cutoff = this.filter.frequency;
        this.addPort(this.cutoff, "cutoff");
        this.cutoff.setup(20.0, 2000.0, 5000.0);
        this.resonance = this.filter.Q;
        this.addPort(this.resonance, "Q");
        this.sweepDepth = this.sweepScaler.inputB;
        this.addPort(this.sweepDepth, "sweepDepth");
        this.sweepDepth.setup(0.0, 0.6, 1.0);
        this.sweepRate = this.samplee.frequency;
        this.addPort(this.sweepRate, "sweepRate");
        this.sweepRate.setup(0.2, 5.9271, 20.0);
        this.pulseRate = this.pulser.frequency;
        this.addPort(this.pulseRate, "pulseRate");
        this.pulseRate.setup(0.2, 7.0, 20.0);
        this.pulseWidth = this.pulser.width;
        this.addPort(this.pulseWidth, "pulseWidth");
        this.pulseWidth.setup(-0.9, 0.9, 0.9);
        this.attack = this.ampEnv.attack;
        this.addPort(this.attack, "attack");
        this.attack.setup(0.001, 0.001, 2.0);
        this.decay = this.ampEnv.decay;
        this.addPort(this.decay, "decay");
        this.decay.setup(0.001, 0.26, 2.0);
        this.sustain = this.ampEnv.sustain;
        this.addPort(this.sustain, "sustain");
        this.sustain.setup(0.0, 0.24, 1.0);
        this.release = this.ampEnv.release;
        this.addPort(this.release, "release");
        this.release.setup(0.001, 0.2, 2.0);
        this.output = this.ampEnv.output;
        this.addPort(this.output);
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }
}

