/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.research;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.ContinuousRamp;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.PowerOfTwo;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitFilter;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.util.WaveRecorder;
import java.io.File;
import java.io.IOException;

public class RecordVariousRamps {
    private Synthesizer synth;
    private UnitOscillator osc;
    private Multiply multiplier;
    private UnitFilter ramp;
    private LinearRamp linearRamp;
    private ContinuousRamp continuousRamp;
    private LineOut lineOut;
    private WaveRecorder recorder;
    private PowerOfTwo powerOfTwo;
    private static final int MODE_STEP = 0;
    private static final int MODE_LINEAR = 1;
    private static final int MODE_SMOOTH = 2;
    private static final String[] modeNames = new String[]{"step", "linear", "smooth"};
    private RampEvent[] rampData = new RampEvent[]{new RampEvent(1.0, 1.5, 2.0), new RampEvent(-0.9, 0.5, 1.0), new RampEvent(0.9, 0.5, 0.8), new RampEvent(-0.3, 0.5, 0.8), new RampEvent(0.9, 0.5, 0.3), new RampEvent(-0.5, 0.5, 0.3), new RampEvent(0.8, 2.0, 1.0)};

    private void test(int mode) throws IOException {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        File waveFile = new File("ramp_pitch_" + modeNames[mode] + ".wav");
        this.recorder = new WaveRecorder(this.synth, waveFile, 1, 16);
        System.out.println("Writing to 16-bit WAV file " + waveFile.getAbsolutePath());
        this.osc = new SawtoothOscillatorBL();
        this.synth.add(this.osc);
        this.multiplier = new Multiply();
        this.synth.add(this.multiplier);
        this.powerOfTwo = new PowerOfTwo();
        this.synth.add(this.powerOfTwo);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.multiplier.inputB.set(660.0);
        switch (mode) {
            case 0: {
                this.ramp = new PassThrough();
                this.synth.add(this.ramp);
                break;
            }
            case 1: {
                this.linearRamp = new LinearRamp();
                this.ramp = this.linearRamp;
                this.synth.add(this.linearRamp);
                this.linearRamp.current.set(-1.0);
                this.linearRamp.time.set(10.0);
                break;
            }
            case 2: {
                this.continuousRamp = new ContinuousRamp();
                this.ramp = this.continuousRamp;
                this.synth.add(this.continuousRamp);
                this.continuousRamp.current.set(-1.0);
                this.continuousRamp.time.set(10.0);
            }
        }
        this.ramp.getInput().set(-1.0);
        this.ramp.getOutput().connect(this.powerOfTwo.input);
        this.powerOfTwo.output.connect(this.multiplier.inputA);
        this.multiplier.output.connect(this.osc.frequency);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.synth.start();
        this.osc.output.connect(0, this.recorder.getInput(), 0);
        this.recorder.start();
        this.lineOut.start();
        double nextEventTime = this.synth.getCurrentTime() + 1.0;
        try {
            this.synth.sleepUntil(nextEventTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RampEvent[] rampEventArray = this.rampData;
        int n = this.rampData.length;
        int n2 = 0;
        while (n2 < n) {
            RampEvent rampEvent = rampEventArray[n2];
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.linearRamp.time.set(rampEvent.rampDuration);
                    break;
                }
                case 2: {
                    this.continuousRamp.time.set(rampEvent.rampDuration);
                }
            }
            this.ramp.getInput().set(rampEvent.target);
            nextEventTime += rampEvent.eventDuration;
            System.out.println("target = " + rampEvent.target + ", rampDur = " + rampEvent.rampDuration + ", eventDur = " + rampEvent.eventDuration);
            try {
                this.synth.sleepUntil(nextEventTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        if (this.recorder != null) {
            this.recorder.stop();
            this.recorder.close();
        }
        this.synth.stop();
    }

    public static void main(String[] args) {
        try {
            new RecordVariousRamps().test(0);
            new RecordVariousRamps().test(1);
            new RecordVariousRamps().test(2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class RampEvent {
        double target;
        double eventDuration;
        double rampDuration;

        RampEvent(double target, double eventDuration, double rampDuration) {
            this.target = target;
            this.eventDuration = eventDuration;
            this.rampDuration = rampDuration;
        }
    }
}

