/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.UnitGate;

public class EnvelopeAttackDecay
extends UnitGate {
    public static final double THRESHOLD = 0.01;
    private static final double MIN_DURATION = 1.0E-5;
    public UnitInputPort attack;
    public UnitInputPort decay;
    public UnitInputPort amplitude;
    private State state = State.IDLE;
    private double scaler = 1.0;
    private double level;
    private double increment;

    public EnvelopeAttackDecay() {
        this.attack = new UnitInputPort("Attack");
        this.addPort(this.attack);
        this.attack.setup(0.001, 0.05, 8.0);
        this.decay = new UnitInputPort("Decay");
        this.addPort(this.decay);
        this.decay.setup(0.001, 0.2, 8.0);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.startIdle();
    }

    public void export(Circuit circuit, String prefix) {
        circuit.addPort(this.attack, String.valueOf(prefix) + this.attack.getName());
        circuit.addPort(this.decay, String.valueOf(prefix) + this.decay.getName());
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        int i = start;
        block5: while (i < limit) {
            boolean triggered = this.input.checkGate(i);
            block0 : switch (this.state) {
                case IDLE: {
                    while (i < limit) {
                        outputs[i] = this.level;
                        if (triggered) {
                            this.startAttack(i);
                            break block0;
                        }
                        ++i;
                    }
                    continue block5;
                }
                case ATTACKING: {
                    while (i < limit) {
                        this.level += this.increment;
                        if (this.level >= 1.0) {
                            this.level = 1.0;
                            outputs[i] = this.level * amplitudes[i];
                            this.startDecay(i);
                            break block0;
                        }
                        outputs[i] = this.level * amplitudes[i];
                        ++i;
                    }
                    continue block5;
                }
                case DECAYING: {
                    while (i < limit) {
                        outputs[i] = this.level * amplitudes[i];
                        this.level *= this.scaler;
                        if (triggered) {
                            this.startAttack(i);
                            break block0;
                        }
                        if (this.level < 3.0517578125E-5) {
                            this.input.checkAutoDisable();
                            this.startIdle();
                            break block0;
                        }
                        ++i;
                    }
                    continue block5;
                }
            }
        }
    }

    private void startIdle() {
        this.state = State.IDLE;
        this.level = 0.0;
    }

    private void startAttack(int i) {
        double[] attacks = this.attack.getValues();
        double duration = attacks[i];
        if (duration < 1.0E-5) {
            this.level = 1.0;
            this.startDecay(i);
        } else {
            this.increment = this.getFramePeriod() / duration;
            this.state = State.ATTACKING;
        }
    }

    private void startDecay(int i) {
        double[] decays = this.decay.getValues();
        double duration = decays[i];
        if (duration < 1.0E-5) {
            this.startIdle();
        } else {
            this.scaler = this.getSynthesisEngine().convertTimeToExponentialScaler(duration);
            this.state = State.DECAYING;
        }
    }

    private static enum State {
        IDLE,
        ATTACKING,
        DECAYING;

    }
}

