/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.Add;
import junit.framework.TestCase;

public class TestConnections
extends TestCase {
    Add add1;
    Add add2;
    Add add3;
    Synthesizer synth;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.synth = JSyn.createSynthesizer();
        this.add1 = new Add();
        this.synth.add(this.add1);
        this.add2 = new Add();
        this.synth.add(this.add2);
        this.add3 = new Add();
        this.synth.add(this.add3);
        this.add1.start();
        this.add2.start();
        this.add3.start();
        this.add1.inputA.set(0.1);
        this.add1.inputB.set(0.2);
        this.add2.inputA.set(0.4);
        this.add2.inputB.set(0.8);
        this.add3.inputA.set(1.6);
        this.add3.inputB.set(3.2);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSet() throws InterruptedException {
        this.synth.sleepFor(0.01);
        TestConnections.assertEquals("set inputs of adder", 0.3, this.add1.output.getValue(), 1.0E-4);
    }

    public void testConnect() throws InterruptedException {
        this.synth.sleepFor(0.01);
        TestConnections.assertEquals("set inputs of adder", 0.3, this.add1.output.getValue(), 1.0E-4);
        TestConnections.assertEquals("set inputs of adder", 1.2, this.add2.output.getValue(), 1.0E-4);
        this.add1.output.connect(this.add2.inputB);
        this.checkConnection();
        this.add1.output.connect(0, this.add2.inputB, 0);
        this.checkConnection();
        this.add1.output.connect(this.add2.inputB.getConnectablePart(0));
        this.checkConnection();
        this.add1.output.getConnectablePart(0).connect(this.add2.inputB);
        this.checkConnection();
        this.add1.output.getConnectablePart(0).connect(this.add2.inputB.getConnectablePart(0));
        this.checkConnection();
        this.add2.inputB.connect(this.add1.output);
        this.checkConnection();
        this.add2.inputB.connect(0, this.add1.output, 0);
        this.checkConnection();
        this.add2.inputB.connect(this.add1.output.getConnectablePart(0));
        this.checkConnection();
        this.add2.inputB.getConnectablePart(0).connect(this.add1.output);
        this.checkConnection();
        this.add2.inputB.getConnectablePart(0).connect(this.add1.output.getConnectablePart(0));
        this.checkConnection();
    }

    private void checkConnection() throws InterruptedException {
        this.synth.sleepFor(0.01);
        TestConnections.assertEquals("connection should not change output", 0.3, this.add1.output.getValue(), 1.0E-4);
        TestConnections.assertEquals("replace set value with output", 0.7, this.add2.output.getValue(), 1.0E-4);
        this.add1.output.disconnectAll();
        this.synth.sleepFor(0.01);
        TestConnections.assertEquals("still the same", 0.3, this.add1.output.getValue(), 1.0E-4);
        TestConnections.assertEquals("should revert to original set() value", 1.2, this.add2.output.getValue(), 1.0E-4);
    }
}

