/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.UnitGate;
import junit.framework.TestCase;

public class TestUnitGate
extends TestCase {
    protected SynthesisEngine synthesisEngine;
    protected double time;

    public void checkAutoDisable(LinearRamp ramp, UnitGate envelope) throws InterruptedException {
        double tolerance = 0.01;
        Add adder = new Add();
        this.synthesisEngine.add(adder);
        envelope.output.connect(adder.inputA);
        if (ramp.getCircuit() != null) {
            ramp.output.connect(adder.inputB);
        }
        envelope.input.setAutoDisableEnabled(true);
        envelope.setEnabled(false);
        ramp.current.set(0.0);
        ramp.input.set(1.0);
        ramp.time.set(1.0);
        this.synthesisEngine.start();
        adder.start();
        this.time = this.synthesisEngine.getCurrentTime();
        this.time += 0.1;
        this.synthesisEngine.sleepUntil(this.time);
        TestUnitGate.assertEquals("still idling", (Object)0.0, (Object)envelope.output.getValue());
        TestUnitGate.assertEquals("ramp frozen at beginning", 0.0, ramp.output.getValue(), tolerance);
        int i = 0;
        while (i < 3) {
            double level = ramp.output.getValue();
            envelope.input.on();
            this.time += 0.1;
            this.synthesisEngine.sleepUntil(this.time);
            TestUnitGate.assertEquals("ramp going up " + i, level += 0.1, ramp.output.getValue(), tolerance);
            TestUnitGate.assertTrue("enabled at peak", envelope.isEnabled());
            envelope.input.off();
            this.time += 0.1;
            this.synthesisEngine.sleepUntil(this.time);
            TestUnitGate.assertEquals("ramp going up more " + i, level += 0.1, ramp.output.getValue(), tolerance);
            TestUnitGate.assertEquals("at bottom", 0.0, envelope.output.getValue(), 0.1);
            this.time += 0.2;
            this.synthesisEngine.sleepUntil(this.time);
            TestUnitGate.assertEquals("ramp frozen " + i, level, ramp.output.getValue(), tolerance);
            ++i;
        }
    }
}

