/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.util.PseudoRandom;
import junit.framework.TestCase;

public class TestPseudoRandom
extends TestCase {
    PseudoRandom pseudoRandom;
    private int[] bins;
    private static final int BIN_SHIFTER = 8;
    private static final int BIN_COUNT = 256;
    private static final int BIN_MASK = 255;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.pseudoRandom = new PseudoRandom();
        this.bins = new int[256];
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMath() {
        long seed = 3964771111L;
        int positiveInt = (int)(seed & Integer.MAX_VALUE);
        TestPseudoRandom.assertTrue("masked random positive, " + positiveInt, positiveInt >= 0);
        double rand = (double)positiveInt * 4.656612873077393E-10;
        TestPseudoRandom.assertTrue("not too low, " + rand, rand >= 0.0);
        TestPseudoRandom.assertTrue("not too high, " + rand, rand < 1.0);
    }

    public void testIntegerDistribution() {
        int scaler = 100;
        int i = 0;
        while (i < this.bins.length * scaler) {
            int index;
            int rand = this.pseudoRandom.nextRandomInteger();
            int positiveInt = rand & Integer.MAX_VALUE;
            TestPseudoRandom.assertTrue("masked random " + positiveInt, positiveInt >= 0);
            int n = index = rand >> 24 & 0xFF;
            this.bins[n] = this.bins[n] + 1;
            ++i;
        }
        this.checkDistribution(scaler);
    }

    public void test01Distribution() {
        int scaler = 100;
        int i = 0;
        while (i < this.bins.length * scaler) {
            int index;
            double rand = this.pseudoRandom.random();
            TestPseudoRandom.assertTrue("not too low, #" + i + " = " + rand, rand >= 0.0);
            TestPseudoRandom.assertTrue("not too high, #" + i + " = " + rand, rand < 1.0);
            int n = index = (int)(rand * 256.0);
            this.bins[n] = this.bins[n] + 1;
            ++i;
        }
        this.checkDistribution(scaler);
    }

    private void checkDistribution(int scaler) {
        double average = scaler;
        double coefficient = 0.9;
        int i = 0;
        while (i < this.bins.length) {
            average = average * coefficient + (double)this.bins[i] * (1.0 - coefficient);
            TestPseudoRandom.assertEquals("average at " + i, (double)scaler, average, 0.2 * (double)scaler);
            ++i;
        }
    }
}

