/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui;

import com.syntona.gui.KeyDispatchOnCapsLock;
import com.syntona.gui.patch.PatchEditor;
import com.syntona.gui.patch.TopPatchEditor;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.EngineController;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class SyntonaFrame
extends JFrame {
    private EngineController engine;
    private TopPatchEditor topPatchEditor;
    private JToolBar toolbar;
    private KeyDispatchOnCapsLock keyDispatcher;
    private static Logger logger = Logger.getLogger(PatchModulePresenter.class.getName());

    public SyntonaFrame(EngineController engine2) {
        this.engine = engine2;
        this.setLocation(20, 20);
        this.setSize(900, 700);
        this.makeToolbar();
        this.makeTabs();
        this.makeMenus();
        this.updateTitle();
        logger.info("Syntona version = 0.5.12, build 39");
        String javaInfo = "Java version = " + System.getProperty("java.version");
        javaInfo = String.valueOf(javaInfo) + ", vendor = " + System.getProperty("java.vendor");
        logger.info(javaInfo);
    }

    private void updateTitle() {
        this.setTitle("Syntona V0.5.12, build 39");
    }

    private void makeToolbar() {
        JPanel toolbarPanel = new JPanel();
        this.toolbar = new JToolBar();
        this.toolbar.add(new JLabel("Syntona Toolbar:"));
        this.keyDispatcher = new KeyDispatchOnCapsLock();
        this.toolbar.add(this.keyDispatcher);
        toolbarPanel.add(this.toolbar);
        for (Bundle bundle : SyntonaEngine.getInstance().getBundles()) {
            JToolBar bundleToolbar = bundle.getToolbar();
            if (bundleToolbar == null) continue;
            toolbarPanel.add(bundleToolbar);
        }
        this.getContentPane().add((Component)toolbarPanel, "North");
    }

    private void makeTabs() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.topPatchEditor = new TopPatchEditor(this.engine);
        tabbedPane.addTab("Patch", null, this.topPatchEditor, "Connect modules together.");
        this.getContentPane().add((Component)tabbedPane, "Center");
    }

    private void makeMenus() {
        Action[] actions;
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        Action[] actionArray = actions = this.engine.getFileMenuItemActions();
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action itemAction = actionArray[n2];
            fileMenu.add(itemAction);
            ++n2;
        }
        menuBar.add(fileMenu);
        JMenu editmenu = new JMenu("Edit");
        Action[] actionArray2 = actions = this.engine.getEditMenuItemActions();
        int n3 = actions.length;
        n = 0;
        while (n < n3) {
            Action itemAction = actionArray2[n];
            JMenuItem item = new JMenuItem(itemAction);
            editmenu.add(item);
            ++n;
        }
        menuBar.add(editmenu);
        this.topPatchEditor.addMenus(menuBar);
        this.setJMenuBar(menuBar);
    }

    public PatchEditor getFrontPatchEditor() {
        return this.topPatchEditor.getFrontPatchEditor();
    }

    public void addPlayKeyListener(KeyListener listener) {
        if (this.keyDispatcher != null) {
            this.keyDispatcher.addPlayKeyListener(listener);
        }
    }

    public void removePlayKeyListener(KeyListener listener) {
        if (this.keyDispatcher != null) {
            this.keyDispatcher.removePlayKeyListener(listener);
        }
    }

    public void setPlayKeysOverride(boolean b) {
        if (this.keyDispatcher != null) {
            this.keyDispatcher.setPlayKeysOverride(b);
        }
    }
}

