/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.TopPatchEditor;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.ModuleDoc;
import com.syntona.plugin.ModuleHelper;
import com.syntona.plugin.ModuleInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ModulePickerTree
extends JPanel {
    private static final String SYNTONA_DROP_HEADER = "syntona";
    private JTree tree;
    private JScrollPane listScroller;
    private TopPatchEditor topPatchEditor;

    public ModulePickerTree(EngineController engine, TopPatchEditor topPatchEditor) {
        this.topPatchEditor = topPatchEditor;
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Modules");
        for (Bundle bundle : engine.getBundles()) {
            MutableTreeNode item = this.makeTopBundleTreeNode(bundle);
            top.add(item);
        }
        this.tree = new JTree(top);
        this.tree.setTransferHandler(new FromTreeTransferHandler());
        this.listScroller = new JScrollPane(this.tree);
        this.listScroller.setPreferredSize(new Dimension(250, 80));
        this.add((Component)this.listScroller, "Center");
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = ModulePickerTree.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 2) {
                        ModulePickerTree.this.makeModuleFromNode();
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        ModulePickerTree.this.showHelpMenuForNode(e);
                    }
                }
            }
        };
        this.tree.addMouseListener(ml);
        this.tree.setDragEnabled(true);
    }

    public static boolean isValidDrop(String data) {
        return data.startsWith(SYNTONA_DROP_HEADER);
    }

    protected void makeModuleFromNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            ModuleInfo moduleInfo = (ModuleInfo)node.getUserObject();
            System.out.println("Make module " + moduleInfo);
            this.topPatchEditor.addModuleToFrontPatch(moduleInfo);
        }
    }

    protected void showHelpMenuForNode(MouseEvent e) {
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        this.tree.setSelectionPath(selPath);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            ModuleInfo moduleInfo = (ModuleInfo)node.getUserObject();
            final ModuleDoc documentation = moduleInfo.getDocumentation();
            final ModuleHelper help = moduleInfo.getHelp();
            if (documentation != null || help != null) {
                JPopupMenu headerMenu = new JPopupMenu();
                JMenuItem menuItem = new JMenuItem("Doc...");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        documentation.show();
                    }
                });
                menuItem.setEnabled(documentation != null);
                headerMenu.add(menuItem);
                menuItem = new JMenuItem("Help...");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        help.show();
                    }
                });
                menuItem.setEnabled(help != null);
                headerMenu.add(menuItem);
                headerMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private MutableTreeNode makeTopBundleTreeNode(Bundle bundle) {
        HashMap<String, DefaultMutableTreeNode> groupMap = new HashMap<String, DefaultMutableTreeNode>();
        DefaultMutableTreeNode bundleNode = new DefaultMutableTreeNode(bundle.getName());
        Iterator<ModuleInfo> infos = bundle.getModuleInfos();
        while (infos.hasNext()) {
            ModuleInfo moduleInfo = infos.next();
            DefaultMutableTreeNode item = new DefaultMutableTreeNode(moduleInfo);
            String groupName = moduleInfo.getGroup();
            if (groupName != null) {
                DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupMap.get(groupName);
                if (groupNode == null) {
                    groupNode = new DefaultMutableTreeNode(groupName);
                    groupMap.put(groupName, groupNode);
                    bundleNode.add(groupNode);
                }
                groupNode.add(item);
                continue;
            }
            bundleNode.add(item);
        }
        return bundleNode;
    }

    private class FromTreeTransferHandler
    extends TransferHandler {
        private FromTreeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ModulePickerTree.this.tree.getLastSelectedPathComponent();
            if (node.isLeaf()) {
                ModuleInfo moduleInfo = (ModuleInfo)node.getUserObject();
                return new StringSelection("syntona," + moduleInfo.getBundle().getName() + "," + moduleInfo.getType());
            }
            return null;
        }
    }
}

