/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.data.SequentialDataCommon;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.jsyn.DataQueueInputJack;
import com.syntona.model.jsyn.DataQueueOutputJack;
import com.syntona.model.jsyn.PatchMessageQueueCommand;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.SyntonaModule;
import java.util.Iterator;

public class SequentialDataModuleBase
extends SyntonaModule {
    protected final DataQueueOutputJack output;
    private SequentialDataCommon mSequentialData;
    boolean immediate = true;

    public SequentialDataModuleBase(SequentialDataCommon sequentialData) {
        this.mSequentialData = sequentialData;
        this.output = this.initJacks();
    }

    public SequentialDataModuleBase(String help) {
        super(help);
        this.output = this.initJacks();
    }

    private DataQueueOutputJack initJacks() {
        new InputActionJack(this, "on", "queue ON portion"){

            @Override
            public void execute() {
                SequentialDataModuleBase.this.queueOn();
            }
        };
        new InputActionJack(this, "off", "queue OFF portion"){

            @Override
            public void execute() {
                SequentialDataModuleBase.this.queueOff();
            }
        };
        new InputActionJack(this, "queue", "queue all of the data"){

            @Override
            public void execute() {
                SequentialDataModuleBase.this.sendQueueCommand(2);
            }
        };
        return new DataQueueOutputJack(this, "output", "sequential data");
    }

    public SequentialDataCommon getSequentialData() {
        return this.mSequentialData;
    }

    protected void queueOn() {
        this.sendQueueCommand(0);
    }

    protected void queueOff() {
        this.sendQueueCommand(1);
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    protected void sendQueueCommand(int opcode) {
        PatchMessageQueueCommand queueCommand = new PatchMessageQueueCommand(this.mSequentialData, opcode);
        queueCommand.setImmediate(this.immediate);
        this.output.passMessage(queueCommand);
    }

    @Override
    public void noteOn(double frequency, double amplitude) {
        super.noteOn(frequency, amplitude);
        this.queueOn();
    }

    @Override
    public void noteOff() {
        this.queueOff();
        super.noteOff();
    }

    protected void exportQueueToConnected(IndentingWriter writer, String methodName, String extras) {
        Iterator<Jack> jacks = this.output.getConnected();
        while (jacks.hasNext()) {
            DataQueueInputJack inputJack = (DataQueueInputJack)jacks.next();
            String targetName = inputJack.getModule().getExportName();
            writer.println(String.valueOf(targetName) + ".dataQueue." + methodName + "( " + this.getExportName() + extras + ");");
        }
    }
}

