/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.unitgen.UnitGate;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.plugin.SyntonaModule;

public class UnitGenModule
extends SyntonaModule {
    protected UnitGenerator ugen;

    public UnitGenModule() {
    }

    public void setup(UnitGenerator sound) {
        this.ugen = sound;
    }

    public UnitGenModule(String help) {
        super(help);
    }

    public UnitGenerator getSound() {
        return this.ugen;
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        String className = this.getExportedClassName();
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 0: {
                exporter.addClass(this.ugen.getClass());
                break;
            }
            case 1: {
                writer.println(String.valueOf(className) + " " + this.getExportName() + ";");
                break;
            }
            case 3: {
                writer.println("add(" + this.getExportName() + " = new " + className + "(" + this.exportConstructorArguments() + "));");
                break;
            }
            case 7: {
                if (!(this.getSound() instanceof UnitGate)) break;
                writer.println(String.valueOf(this.getExportName()) + ".input.on(timeStamp);");
                break;
            }
            case 8: {
                if (!(this.getSound() instanceof UnitGate)) break;
                writer.println(String.valueOf(this.getExportName()) + ".input.off(timeStamp);");
            }
        }
    }

    public String exportConstructorArguments() {
        return "";
    }

    @Override
    public String getExportedClassName() {
        return this.ugen.getClass().getSimpleName();
    }

    String getTagName() {
        return "unit";
    }

    @Override
    public void noteOn(double frequency, double amplitude) {
        super.noteOn(frequency, amplitude);
        if (this.getSound() instanceof UnitGate) {
            UnitGate unitGate = (UnitGate)this.getSound();
            if (!unitGate.input.isConnected()) {
                unitGate.input.on();
            }
        }
    }

    @Override
    public void noteOff() {
        if (this.getSound() instanceof UnitGate) {
            UnitGate unitGate = (UnitGate)this.getSound();
            if (!unitGate.input.isConnected()) {
                unitGate.input.off();
            }
        }
        super.noteOff();
    }
}

