/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.plugin.SyntonaModelListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;

public abstract class SyntonaModel {
    protected String name = "Unnamed";
    private String help = "";
    private CopyOnWriteArrayList<SyntonaModelListener> listeners = new CopyOnWriteArrayList();

    public SyntonaModel() {
    }

    public SyntonaModel(String name, String help) {
        this.name = name;
        this.help = help;
    }

    private void fireNameChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (SyntonaModelListener modelListener : SyntonaModel.this.listeners) {
                        modelListener.nameChanged(SyntonaModel.this);
                    }
                }
            });
        }
    }

    public void fireOnOffChanged(final boolean onOrOff) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (SyntonaModelListener modelListener : SyntonaModel.this.listeners) {
                        modelListener.onOffChanged(SyntonaModel.this, onOrOff);
                    }
                }
            });
        }
    }

    public void fireIndexChanged(final int index) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (SyntonaModelListener modelListener : SyntonaModel.this.listeners) {
                        modelListener.indexChanged(SyntonaModel.this, index);
                    }
                }
            });
        }
    }

    public void addModelListener(SyntonaModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(SyntonaModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireNameChanged();
    }

    public String getToolTipText() {
        return String.valueOf(this.name) + ", " + this.help;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }
}

