/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.model.SyntonaEngine;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.core.PatchModule;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.PatchMessageDouble;
import com.syntona.plugin.SyntonaModel;
import com.syntona.plugin.SyntonaModuleListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

public class SyntonaModule
extends SyntonaModel {
    public static final String NAME_ON = "on";
    public static final String NAME_OFF = "off";
    private PatchModule parent;
    protected String type = "UnknownType";
    private Bundle bundle;
    private int saveId;
    private int id;
    private final List<Jack> jacks;
    private static Jack[] jackType = new Jack[0];
    private final CopyOnWriteArrayList<SyntonaModuleListener> listeners = new CopyOnWriteArrayList();
    private Jack lastActive = null;

    public SyntonaModule() {
        this.jacks = new ArrayList<Jack>();
    }

    public SyntonaModule(String help) {
        this();
        this.setHelp(help);
    }

    public void fireJackAdded(Jack jack) {
        for (SyntonaModuleListener moduleListener : this.listeners) {
            moduleListener.jackAdded(this, jack);
        }
    }

    public void fireJackRemoved(Jack jack) {
        for (SyntonaModuleListener moduleListener : this.listeners) {
            moduleListener.jackRemoved(this, jack);
        }
    }

    public void addModuleListener(SyntonaModuleListener moduleListener) {
        this.listeners.add(moduleListener);
    }

    public void removeModuleListener(SyntonaModuleListener moduleListener) {
        this.listeners.remove(moduleListener);
    }

    public Jack[] getJacks() {
        return this.jacks.toArray(jackType);
    }

    public void addJack(Jack jack) {
        this.jacks.add(jack);
        this.fireJackAdded(jack);
    }

    public void removeJack(Jack jack) {
        jack.disconnect();
        this.jacks.remove(jack);
        this.fireJackRemoved(jack);
    }

    public Jack getJackByName(String name) {
        Jack[] jackArray;
        Jack[] jackArray2 = jackArray = this.getJacks();
        int n = jackArray.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray2[n2];
            if (jack.getName().equals(name)) {
                return jack;
            }
            ++n2;
        }
        return null;
    }

    public void kick() {
    }

    public void shutdown() {
    }

    public EngineController getEngine() {
        return SyntonaEngine.getInstance();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSaveId() {
        return this.saveId;
    }

    public void setSaveId(int id) {
        this.saveId = id;
    }

    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void addedToPatch(PatchModule parent) {
        this.parent = parent;
    }

    public void removedFromPatch() {
        this.parent = null;
    }

    public PatchModule getParent() {
        return this.parent;
    }

    public void onDelete() {
    }

    public void disconnectAllJacks() {
        for (Jack jack : this.jacks) {
            jack.disconnect();
        }
    }

    public boolean isExportable() {
        return false;
    }

    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        if (this.isExportable()) {
            Jack[] jackArray = this.getJacks();
            int n = jackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Jack jack = jackArray[n2];
                jack.exportJavaSource(exporter, phase);
                ++n2;
            }
        }
    }

    public String getExportedClassName() {
        return this.getClass().getName();
    }

    public void saveAttributes(SyntonaSaver saver) {
        saver.addAttribute("bundle", this.getBundle().getName());
        saver.addAttribute("type", this.getType());
        saver.addAttribute("name", this.getName());
        saver.addAttribute("id", "" + this.getSaveId());
    }

    public void saveJacks(SyntonaSaver saver) {
        Jack[] jackArray = this.getJacks();
        int n = jackArray.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            jack.save(saver);
            ++n2;
        }
    }

    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException {
    }

    public void onLoad() {
    }

    public void noteOn(double frequency, double amplitude) {
    }

    public void noteOff() {
    }

    public String getExportName() {
        return SyntonaExporter.toAndroidMemberName(this.getName());
    }

    public Jack[] getJacksToEdit() {
        return this.getJacks();
    }

    public void outputSingleActive(PatchMessage msg, OutputDoubleJack output) {
        output.passMessage(msg);
        this.changeActiveJack(output);
    }

    protected void changeActiveJack(Jack jack) {
        if (this.lastActive != null) {
            this.lastActive.fireOnOffChanged(false);
        }
        jack.fireOnOffChanged(true);
        this.lastActive = jack;
    }

    public int getConnectableInputJackCount() {
        int count = 0;
        Jack[] jackArray = this.getJacks();
        int n = jackArray.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            if (jack.isConnectable() && jack instanceof InputJack) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int getConnectableOutputJackCount() {
        int count = 0;
        Jack[] jackArray = this.getJacks();
        int n = jackArray.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            if (jack.isConnectable() && jack instanceof OutputJack) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public void passDoubleMessage(double value, OutputDoubleJack jack) {
        PatchMessageDouble msg = new PatchMessageDouble(value);
        jack.passMessage(msg);
    }
}

