/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.benchmarks;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.PitchDetector;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SquareOscillator;
import com.jsyn.unitgen.SquareOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import com.softsynth.math.FourierMath;

public class BenchJSyn {
    private Synthesizer synth;
    private long startTime;
    private long endTime;
    private PassThrough pass;

    public void run() {
        try {
            int i = 0;
            while (i < 4) {
                this.benchmark();
                ++i;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void benchmark() throws InstantiationException, IllegalAccessException, InterruptedException {
        double realTime = 10.0;
        int count = 40;
        this.benchmarkOscillator(SquareOscillator.class, count, realTime);
        this.benchmarkOscillator(SquareOscillatorBL.class, count, realTime);
        this.benchmarkOscillator(SineOscillator.class, count, realTime);
        this.benchmarkPitchDetector(count, realTime);
    }

    public void benchFFTDouble() {
        int size = 2048;
        int bin = 5;
        int count = 20000;
        double[] ar = new double[size];
        double[] ai = new double[size];
        double[] magnitudes = new double[size];
        double amplitude = 1.0;
        this.addSineWave(size, bin, ar, amplitude);
        System.out.println("Bench double FFT");
        this.startTiming();
        int i = 0;
        while (i < count) {
            FourierMath.transform(1, size, ar, ai);
            ++i;
        }
        this.endTiming(FourierMath.class, count, (double)size / 88200.0);
        FourierMath.calculateMagnitudes(ar, ai, magnitudes);
        assert (magnitudes[bin - 1] < 0.001);
        assert (magnitudes[bin] > 0.5);
        assert (magnitudes[bin + 1] < 0.001);
    }

    public void benchFFTFloat() {
        int size = 2048;
        int bin = 5;
        int count = 20000;
        float[] ar = new float[size];
        float[] ai = new float[size];
        float[] magnitudes = new float[size];
        float amplitude = 1.0f;
        this.addSineWave(size, bin, ar, amplitude);
        System.out.println("Bench float FFT");
        this.startTiming();
        int i = 0;
        while (i < count) {
            FourierMath.transform(1, size, ar, ai);
            ++i;
        }
        this.endTiming(FourierMath.class, count, (double)size / 88200.0);
        FourierMath.calculateMagnitudes(ar, ai, magnitudes);
        assert ((double)magnitudes[bin - 1] < 0.001);
        assert ((double)magnitudes[bin] > 0.5);
        assert ((double)magnitudes[bin + 1] < 0.001);
    }

    private void addSineWave(int size, int bin, double[] ar, double amplitude) {
        double phase = 0.0;
        double phaseIncrement = Math.PI * 2 * (double)bin / (double)size;
        int i = 0;
        while (i < size) {
            int n = i++;
            ar[n] = ar[n] + Math.sin(phase) * amplitude;
            phase += phaseIncrement;
        }
    }

    private void addSineWave(int size, int bin, float[] ar, float amplitude) {
        float phase = 0.0f;
        float phaseIncrement = (float)(Math.PI * 2 * (double)bin / (double)size);
        int i = 0;
        while (i < size) {
            int n = i++;
            ar[n] = ar[n] + (float)Math.sin(phase) * amplitude;
            phase += phaseIncrement;
        }
    }

    private void stopSynth() {
        this.synth.stop();
    }

    private void startSynth() {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        this.pass = new PassThrough();
        this.synth.add(this.pass);
        this.synth.start();
        this.pass.start();
    }

    private void benchmarkOscillator(Class<?> clazz, int count, double realTime) throws InstantiationException, IllegalAccessException, InterruptedException {
        this.startSynth();
        int i = 0;
        while (i < count) {
            UnitOscillator osc = (UnitOscillator)clazz.newInstance();
            osc.output.connect(this.pass.input);
            this.synth.add(osc);
            ++i;
        }
        this.startTiming();
        this.synth.sleepFor(realTime);
        this.endTiming(clazz, count, realTime);
        this.stopSynth();
    }

    private void benchmarkPitchDetector(int count, double realTime) throws InstantiationException, IllegalAccessException, InterruptedException {
        this.startSynth();
        PitchDetector detector = new PitchDetector();
        this.synth.add(detector);
        double frequency = 198.0;
        double period = (double)this.synth.getFrameRate() / frequency;
        int i = 0;
        while (i < count) {
            SineOscillator osc = new SineOscillator();
            this.synth.add(osc);
            osc.frequency.set(frequency * (double)(i + 1));
            osc.amplitude.set(0.5 * (1.0 - (double)i * 0.2));
            osc.output.connect(detector.input);
            ++i;
        }
        detector.start();
        this.startTiming();
        this.synth.sleepFor(realTime);
        this.endTiming(PitchDetector.class, count, realTime);
        double measuredPeriod = detector.period.getValue();
        double confidence = detector.confidence.getValue();
        System.out.println("period = " + period + ", measured = " + measuredPeriod + ", confidence = " + confidence);
        if (confidence > 0.1) assert (Math.abs(measuredPeriod - period) < 0.1);
        this.stopSynth();
    }

    private void endTiming(Class<?> clazz, int count, double realTime) {
        this.endTime = System.nanoTime();
        double elapsedTime = (double)(this.endTime - this.startTime) * 1.0E-9;
        double percent = 100.0 * elapsedTime / (realTime * (double)count);
        System.out.printf("%32s took %5.3f/%d seconds to process %5.4f of audio = %6.3f%c.\n", clazz.getSimpleName(), elapsedTime, count, realTime, percent, Character.valueOf('%'));
    }

    private void startTiming() {
        this.startTime = System.nanoTime();
    }

    public static void main(String[] args) {
        new BenchJSyn().run();
    }
}

