/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.FilterBiquad;

public abstract class FilterBiquadCommon
extends FilterBiquad {
    public UnitInputPort Q = new UnitInputPort("Q");
    protected static final double MINIMUM_Q = 1.0E-5;
    private double previousQ;
    protected double alpha;

    public FilterBiquadCommon() {
        this.addPort(this.Q);
        this.Q.setup(0.1, 1.0, 10.0);
    }

    public abstract void updateCoefficients();

    public void computeBiquadCommon(double ratio, double Q) {
        if (ratio >= 0.499) {
            ratio = 0.499;
        }
        this.omega = Math.PI * 2 * ratio;
        this.cos_omega = Math.cos(this.omega);
        this.sin_omega = Math.sin(this.omega);
        this.alpha = this.sin_omega / (2.0 * Q);
    }

    @Override
    public void recalculate() {
        double frequencyValue = this.frequency.getValues()[0];
        double qValue = this.Q.getValues()[0];
        if (frequencyValue < 1.0E-5) {
            frequencyValue = 1.0E-5;
        }
        if (qValue < 1.0E-5) {
            qValue = 1.0E-5;
        }
        if (this.isRecalculationNeeded(frequencyValue, qValue)) {
            this.previousFrequency = frequencyValue;
            this.previousQ = qValue;
            double ratio = frequencyValue * this.getFramePeriod();
            this.computeBiquadCommon(ratio, qValue);
            this.updateCoefficients();
        }
    }

    protected boolean isRecalculationNeeded(double frequencyValue, double qValue) {
        return frequencyValue != this.previousFrequency || qValue != this.previousQ;
    }
}

