/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.SequentialDataReader;

public class FixedRateStereoReader
extends SequentialDataReader {
    public FixedRateStereoReader() {
        this.output = new UnitOutputPort(2, "Output");
        this.addPort(this.output);
        this.dataQueue.setNumChannels(2);
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues();
        double[] output0s = this.output.getValues(0);
        double[] output1s = this.output.getValues(1);
        int i = start;
        while (i < limit) {
            if (this.dataQueue.hasMore()) {
                this.dataQueue.beginFrame(this.getFramePeriod());
                double fdata = this.dataQueue.readCurrentChannelDouble(0);
                double amp = amplitudes[i];
                output0s[i] = fdata * amp;
                fdata = this.dataQueue.readCurrentChannelDouble(1);
                output1s[i] = fdata * amp;
                this.dataQueue.endFrame();
            } else {
                output0s[i] = 0.0;
                output1s[i] = 0.0;
                if (this.dataQueue.testAndClearAutoStop()) {
                    this.autoStop();
                }
            }
            this.dataQueue.firePendingCallbacks();
            ++i;
        }
    }
}

