/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.MultiTable;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.SawtoothOscillatorBL;

public class PulseOscillatorBL
extends SawtoothOscillatorBL {
    public UnitInputPort width = new UnitInputPort("Width");

    public PulseOscillatorBL() {
        this.addPort(this.width);
    }

    @Override
    protected double generateBL(MultiTable multiTable, double currentPhase, double positivePhaseIncrement, double flevel, int i) {
        double[] widths = this.width.getValues();
        double width = widths[i];
        width = width > 0.999 ? 0.999 : (width < -0.999 ? -0.999 : width);
        double val1 = multiTable.calculateSawtooth(currentPhase, positivePhaseIncrement, flevel);
        double phase2 = currentPhase + 1.0 - width;
        if (phase2 >= 1.0) {
            phase2 -= 2.0;
        }
        double val2 = multiTable.calculateSawtooth(phase2, positivePhaseIncrement, flevel);
        double scale = 1.0 - positivePhaseIncrement;
        return scale * (val1 - val2 - width);
    }
}

