/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.FloatSample;
import com.jsyn.unitgen.GrainCommon;
import com.jsyn.unitgen.GrainSource;

public class SampleGrainSource
extends GrainCommon
implements GrainSource {
    private FloatSample sample;
    private double position;
    private double positionRange;
    private double phase;
    private double phaseIncrement;
    private int numFramesGuarded;
    private static final double MAX_PHASE = 0.9999999999;

    @Override
    public double next() {
        this.phase += this.phaseIncrement;
        if (this.phase > 0.9999999999) {
            this.phase = 0.9999999999;
        }
        double fractionalIndex = this.phase * (double)this.numFramesGuarded;
        return this.sample.interpolate(fractionalIndex);
    }

    @Override
    public void setRate(double rate) {
        this.phaseIncrement = rate * this.sample.getFrameRate() / (this.getFrameRate() * (double)this.numFramesGuarded);
    }

    public void setSample(FloatSample sample) {
        this.sample = sample;
        this.numFramesGuarded = sample.getNumFrames() - 1;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    @Override
    public void reset() {
        double randomPosition = this.position + this.positionRange * (Math.random() - 0.5);
        this.phase = randomPosition * 0.5 + 0.5;
        if (this.phase < 0.0) {
            this.phase = 0.0;
        } else if (this.phase > 0.9999999999) {
            this.phase = 0.9999999999;
        }
    }

    public void setPositionRange(double positionRange) {
        this.positionRange = positionRange;
    }
}

