/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class ZeroCrossingCounter
extends UnitGenerator {
    private static final double THRESHOLD = 1.0E-4;
    public UnitInputPort input = new UnitInputPort("Input");
    public UnitOutputPort output;
    private long count;
    private boolean armed;

    public ZeroCrossingCounter() {
        this.addPort(this.input);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        int i = start;
        while (i < limit) {
            double value = inputs[i];
            if (value < -1.0E-4) {
                this.armed = true;
            } else if (this.armed & value > 1.0E-4) {
                ++this.count;
                this.armed = false;
            }
            outputs[i] = value;
            ++i;
        }
    }

    public long getCount() {
        return this.count;
    }
}

