/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreElementPlayer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ScoreQueue
extends ScoreElement {
    private ConcurrentLinkedQueue<ScoreElement> queue = new ConcurrentLinkedQueue();

    @Override
    public ScoreElementPlayer start(ScoreElementPlayer parentPlayer, double time) {
        QueuePlayer player = new QueuePlayer(this, parentPlayer);
        player.startNext(time);
        return player;
    }

    public void clear() {
        this.queue.clear();
    }

    public void add(ScoreElement element) {
        this.queue.add(element);
    }

    public int size() {
        return this.queue.size();
    }

    private class QueuePlayer
    extends ScoreElementPlayer {
        private double nextTime;
        private boolean done;
        private ScoreElementPlayer currentPlayer;

        private QueuePlayer(ScoreQueue scoreQueue2, ScoreElementPlayer parentPlayer) {
            super(scoreQueue2, parentPlayer);
            this.done = false;
        }

        private void startNext(double time) {
            ScoreElement element = (ScoreElement)ScoreQueue.this.queue.poll();
            if (element == null) {
                this.done = true;
                this.currentPlayer = null;
            } else {
                this.currentPlayer = element.start(this, time);
            }
        }

        @Override
        public double advance(double time) {
            if (time >= this.nextTime && this.currentPlayer != null) {
                this.nextTime = this.currentPlayer.advance(this.nextTime);
                if (this.currentPlayer.isDone()) {
                    this.startNext(this.nextTime);
                }
            }
            return this.nextTime;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }
}

