/*
 * Decompiled with CFR 0.152.
 */
package com.syntona;

import com.syntona.SyntonaGUIService;
import com.syntona.gui.HackAppleKeyPress;
import com.syntona.gui.SyntonaFrame;
import com.syntona.model.GUIService;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.SyntonaPreferences;
import com.syntona.plugin.EngineController;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;

public class Syntona {
    private SyntonaFrame mainFrame;
    private EngineController engine;
    private SyntonaPreferences preferences;
    private HackAppleKeyPress mHackAppleKeyPress = new HackAppleKeyPress();
    private static Logger logger = Logger.getLogger(Syntona.class.getName());

    public static void main(String[] args) {
        Syntona app = new Syntona();
        app.execute();
    }

    private void execute() {
        this.init();
        this.start();
        this.engine.waitForFinish();
        this.stop();
        this.term();
    }

    private void init() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "Uncaught exception in thread " + t, e);
            }
        });
        this.engine = SyntonaEngine.getInstance();
        this.preferences = SyntonaPreferences.getInstance();
        this.mainFrame = new SyntonaFrame(this.engine);
        this.engine.setGUIService(this.createGUIService(this.mainFrame));
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                boolean cancelled = false;
                try {
                    cancelled = Syntona.this.engine.saveTopIfDirty();
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                }
                if (!cancelled) {
                    Syntona.this.stop();
                    Syntona.this.term();
                    Syntona.this.mainFrame.dispose();
                }
            }
        });
    }

    private GUIService createGUIService(SyntonaFrame syntonaFrame) {
        return new SyntonaGUIService(syntonaFrame);
    }

    private void start() {
        this.mHackAppleKeyPress.start();
        Point location = this.preferences.getWindowLocation();
        Dimension size = this.preferences.getWindowSize();
        this.mainFrame.setLocation(location);
        this.mainFrame.setSize(size);
        this.mainFrame.setVisible(true);
        this.engine.start();
    }

    private void stop() {
        this.engine.stop();
        try {
            Point location = this.mainFrame.getLocation();
            this.preferences.setLocation(location);
            Dimension size = this.mainFrame.getSize();
            this.preferences.setSize(size);
            this.preferences.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mHackAppleKeyPress.stop();
    }

    protected void term() {
        int resultCode = 0;
        System.exit(resultCode);
    }
}

