/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.PatchEditor;
import com.syntona.gui.patch.TopPatchEditor;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.EngineController;
import com.syntona.tools.ModificationListener;
import com.syntona.tools.ModificationTracker;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class PatchFrame
extends JInternalFrame {
    private static final String DEFAULT_TITLE = "Patch: Untitled";
    private PatchEditor patchEditor;
    private GlassPatchOverlay patchOverlay;
    private TopPatchEditor topPatchEditor;
    private PatchModulePresenter patchModulePresenter;

    public PatchFrame(EngineController engine, TopPatchEditor topPatchEditor, PatchModulePresenter patchModulePresenter) {
        super(DEFAULT_TITLE, true, true, true, true);
        this.topPatchEditor = topPatchEditor;
        this.patchModulePresenter = patchModulePresenter;
        this.patchEditor = new PatchEditor(engine, topPatchEditor, patchModulePresenter, this);
        this.add((Component)this.patchEditor, "Center");
        this.patchOverlay = new GlassPatchOverlay();
        this.getRootPane().setGlassPane(this.patchOverlay);
        this.patchOverlay.setVisible(true);
        this.setDefaultCloseOperation(0);
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new MyDispatcher());
        patchModulePresenter.setPatchFrame(this);
        patchModulePresenter.addModificationListener(new ModificationListener(){

            @Override
            public void stateChanged(ModificationTracker tracker) {
                PatchFrame.this.updateTitle();
            }
        });
        this.updateTitle();
    }

    public TopPatchEditor getTopPatchEditor() {
        return this.topPatchEditor;
    }

    @Override
    public void paint(Graphics g) {
        this.patchOverlay.setVisible(true);
        super.paint(g);
    }

    public PatchEditor getPatchEditor() {
        return this.patchEditor;
    }

    public PatchModulePresenter getPatchModulePresenter() {
        return this.patchModulePresenter;
    }

    public void updateTitle() {
        File patchFile = this.patchModulePresenter.getFile();
        String title = patchFile == null ? "Patch: " + this.patchModulePresenter.getName() : "Patch: " + patchFile.getAbsolutePath();
        if (this.patchModulePresenter.isDirty()) {
            title = String.valueOf(title) + " *";
        }
        this.setTitle(title);
    }

    public void deselectAll() {
        this.patchEditor.deselectAll();
    }

    class GlassPatchOverlay
    extends JComponent {
        GlassPatchOverlay() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.isShowing()) {
                PatchFrame.this.patchEditor.getPatchBox().drawPatchConnections(g, this.getLocationOnScreen());
            } else {
                System.out.println("Cannot draw connections because frame not showing.");
            }
        }
    }

    private class MyDispatcher
    implements KeyEventDispatcher {
        private MyDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            char c;
            if (e.getID() == 400 && (c = e.getKeyChar()) == '\u007f') {
                SyntonaEngine.getInstance().deleteSelectedModules();
            }
            return false;
        }
    }
}

