/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.syntona.model.SyntonaLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLDOMLoader
implements SyntonaLoader {
    Document document;
    private File loadFile;
    private int offsetX;
    private int offsetY;
    private boolean autoSelectEnabled;
    private static final Logger logger = Logger.getLogger(XMLDOMLoader.class.getName());

    @Override
    public void parse(File loadFile) throws ParserConfigurationException, SAXException, IOException {
        logger.info("parse XML file " + loadFile);
        this.loadFile = loadFile;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = builder.parse(loadFile);
    }

    @Override
    public void parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        logger.info("parse " + inputStream);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = builder.parse(inputStream);
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public static List<Element> getChildrenByTagName(Element parent, String name) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && name.equals(child.getNodeName())) {
                nodeList.add((Element)child);
            }
            child = child.getNextSibling();
        }
        return nodeList;
    }

    public static Element getChildByTagName(Element parent, String name) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && name.equals(child.getNodeName())) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static boolean parseBooleanAttribute(Element element, String name, boolean value) {
        String valueText = element.getAttribute(name);
        if (valueText.length() > 0) {
            value = "true".equals(valueText);
        }
        return value;
    }

    public static boolean parseBooleanAttribute(Element element, String name) {
        return XMLDOMLoader.parseBooleanAttribute(element, name, false);
    }

    public static int parseIntegerAttribute(Element element, String name, int value) {
        String valueText = element.getAttribute(name);
        if (valueText.length() > 0) {
            value = Integer.parseInt(valueText);
        }
        return value;
    }

    public static int parseIntegerAttribute(Element element, String name) {
        return XMLDOMLoader.parseIntegerAttribute(element, name, 0);
    }

    public static long parseLongAttribute(Element element, String name, long value) {
        String valueText = element.getAttribute(name);
        if (valueText.length() > 0) {
            value = Long.parseLong(valueText);
        }
        return value;
    }

    public static long parseLongAttribute(Element element, String name) {
        return XMLDOMLoader.parseLongAttribute(element, name, 0L);
    }

    public static double parseDoubleAttribute(Element element, String name, double value) {
        String valueText = element.getAttribute(name);
        if (valueText.length() > 0) {
            value = Double.parseDouble(valueText);
        }
        return value;
    }

    public static double parseDoubleAttribute(Element element, String name) {
        return XMLDOMLoader.parseDoubleAttribute(element, name, 0.0);
    }

    @Override
    public File getLoadFile() {
        return this.loadFile;
    }

    @Override
    public int getOffsetX() {
        return this.offsetX;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    @Override
    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    @Override
    public boolean isAutoSelectEnabled() {
        return this.autoSelectEnabled;
    }

    @Override
    public void setAutoSelectEnabled(boolean b) {
        this.autoSelectEnabled = b;
    }
}

