/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.softsynth.util.IndentingWriter;
import com.syntona.gui.AlertUser;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.core.PatchModule;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.PatchMessageDouble;
import com.syntona.plugin.SyntonaModule;

public class UnitVoiceModule
extends PatchModule {
    public static final String NAME_FREQUENCY = "frequency";
    public static final String NAME_AMPLITUDE = "amplitude";
    public static final String NAME_OUTPUT = "output";
    private String exportedClassName;

    public UnitVoiceModule() {
        new InputActionJack(this, "on", "note on using message value or \"frequency\" jack value as frequency"){

            @Override
            public void execute(PatchMessage msg) {
                double frequency = msg instanceof PatchMessageDouble ? ((PatchMessageDouble)msg).getValue() : UnitVoiceModule.this.getFrequency();
                double amplitude = UnitVoiceModule.this.getAmplitude();
                UnitVoiceModule.this.noteOn(frequency, amplitude);
            }

            @Override
            public void execute() {
                double frequency = UnitVoiceModule.this.getFrequency();
                double amplitude = UnitVoiceModule.this.getAmplitude();
                UnitVoiceModule.this.noteOn(frequency, amplitude);
            }
        };
        new InputActionJack(this, "off", "turn note off"){

            @Override
            public void execute() {
                UnitVoiceModule.this.noteOff();
            }
        };
    }

    private double getFrequency() {
        double frequency = 440.0;
        InputDoubleJack freqJack = (InputDoubleJack)this.getJackByName(NAME_FREQUENCY);
        if (freqJack != null) {
            frequency = freqJack.getValue();
        }
        return frequency;
    }

    private double getAmplitude() {
        double amplitude = 10.0;
        InputDoubleJack ampJack = (InputDoubleJack)this.getJackByName(NAME_AMPLITUDE);
        if (ampJack != null) {
            amplitude = ampJack.getValue();
        }
        return amplitude;
    }

    @Override
    public void noteOn(double frequency, double amplitude) {
        SyntonaModule[] syntonaModuleArray = this.getModules();
        int n = syntonaModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyntonaModule module = syntonaModuleArray[n2];
            module.noteOn(frequency, amplitude);
            ++n2;
        }
    }

    @Override
    public void noteOff() {
        SyntonaModule[] syntonaModuleArray = this.getModules();
        int n = syntonaModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyntonaModule module = syntonaModuleArray[n2];
            module.noteOff();
            ++n2;
        }
    }

    @Override
    public String getExportedClassName() {
        return this.exportedClassName;
    }

    private void createUniqueClassName(SyntonaExporter exporter) {
        String original = "Inner" + Character.toUpperCase(this.getName().charAt(0)) + this.getName().substring(1);
        this.exportedClassName = exporter.makeClassNameUnique(original);
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 0: {
                this.createUniqueClassName(exporter);
                break;
            }
            case 1: {
                writer.println(String.valueOf(this.getExportedClassName()) + " " + this.getExportedObjectName() + ";");
                break;
            }
            case 2: {
                exporter.export(this);
                break;
            }
            case 3: {
                writer.println("add(" + this.getExportedObjectName() + " = new " + this.getExportedClassName() + "());");
                break;
            }
            case 7: {
                writer.println(String.valueOf(this.getExportedObjectName()) + ".noteOn(frequency, amplitude, timeStamp);");
                break;
            }
            case 8: {
                writer.println(String.valueOf(this.getExportedObjectName()) + ".noteOff(timeStamp);");
            }
        }
    }

    @Override
    public boolean validateExport() {
        boolean ok = true;
        SyntonaModule outputModule = this.findModuleByName(NAME_OUTPUT);
        if (outputModule == null) {
            AlertUser.showError("Voice is missing an output port!");
            ok = false;
        }
        return ok;
    }
}

