/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.InputBitMaskJack;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.SyntonaModule;

public class BooleanGridModule
extends SyntonaModule {
    private InputActionJack reset;
    private InputActionJack clock;
    protected InputBitMaskJack[] inputs;
    protected OutputDoubleJack[] outputs;
    private int counter;
    protected int rowCount;
    protected int columnCount;

    public BooleanGridModule(int rowCount, int columnCount) {
        super("Send bit value to all outputs.");
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.clock = new InputActionJack(this, "clock", "Advance sequence."){

            @Override
            public void execute() {
            }
        };
        this.clock.setKickable(true);
        this.reset = new InputActionJack(this, "reset", "Reset sequence back to zero."){

            @Override
            public void execute() {
                BooleanGridModule.this.counter = 0;
            }
        };
        this.inputs = new InputBitMaskJack[rowCount];
        int i = 0;
        while (i < this.inputs.length) {
            this.inputs[i] = new InputBitMaskJack(this, "in" + i);
            this.inputs[i].setVisible(true);
            this.inputs[i].setConnectable(false);
            this.inputs[i].setColumnCount(columnCount);
            ++i;
        }
        this.outputs = new OutputDoubleJack[rowCount];
        i = 0;
        while (i < this.outputs.length) {
            this.outputs[i] = new OutputDoubleJack(this, "out" + i);
            this.outputs[i].setVisible(false);
            this.outputs[i].setLevelWith(this.inputs[i]);
            ++i;
        }
    }

    @Override
    public void kick() {
        int column = this.counter++;
        if (this.counter >= this.columnCount) {
            this.counter = 0;
        }
        int mask = 1 << column;
        int row = 0;
        while (row < this.rowCount) {
            InputBitMaskJack in = this.inputs[row];
            OutputDoubleJack out = this.outputs[row];
            long bits = in.getValue();
            if ((bits & (long)mask) != 0L) {
                this.passDoubleMessage(1.0, out);
            }
            in.fireIndexChanged(column);
            ++row;
        }
    }
}

