/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.model.music.BeatClock;
import com.syntona.model.music.BeatClockModulePresenter;
import com.syntona.model.music.BooleanGridModule4x16;
import com.syntona.model.music.ConvertFrequencyToPitchModel;
import com.syntona.model.music.ConvertPitchToFrequencyModel;
import com.syntona.model.music.GetTempoModule;
import com.syntona.model.music.KeyboardModuleView;
import com.syntona.model.music.MusicToolBar;
import com.syntona.model.music.NoteGeneratorModel;
import com.syntona.model.music.PitchKeyModulePresenter;
import com.syntona.model.music.SetTempoModule;
import com.syntona.plugin.Bundle;
import javax.swing.JToolBar;

public class MusicBundle
extends Bundle {
    private static Bundle instance = null;
    private static final String GROUP_SEQUENCE = "sequence";
    private MusicToolBar toolbar;
    private BeatClock beatClock = BeatClock.getInstance();

    public static Bundle getInstance() {
        if (instance == null) {
            instance = new MusicBundle();
        }
        return instance;
    }

    @Override
    public String getName() {
        return "music";
    }

    @Override
    public void addClasses() {
        this.addModule(null, "keyboard", NoteGeneratorModel.class, KeyboardModuleView.class);
        this.addModule("cpf", ConvertPitchToFrequencyModel.class);
        this.addModule("cfp", ConvertFrequencyToPitchModel.class);
        this.addModule("pitchKey", PitchKeyModulePresenter.class);
        this.addModule("beatClock", BeatClockModulePresenter.class);
        this.addModule("setTempo", SetTempoModule.class);
        this.addModule("getTempo", GetTempoModule.class);
        this.addModule(GROUP_SEQUENCE, "grid4x16", BooleanGridModule4x16.class);
    }

    @Override
    public JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new MusicToolBar(this.beatClock);
        }
        return this.toolbar;
    }
}

