/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.instruments;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.EnvelopeDAHDSR;
import com.jsyn.unitgen.FilterFourPoles;
import com.jsyn.unitgen.MorphingOscillatorBL;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceDescription;
import com.softsynth.math.AudioMath;
import com.softsynth.shared.time.TimeStamp;

public class DualOscillatorSynthVoice
extends Circuit
implements UnitVoice {
    private Multiply frequencyMultiplier = new Multiply();
    private Multiply amplitudeMultiplier;
    private Multiply detuneScaler1;
    private Multiply detuneScaler2;
    private Multiply amplitudeBoost;
    private MorphingOscillatorBL osc1;
    private MorphingOscillatorBL osc2;
    private FilterFourPoles filter;
    private EnvelopeDAHDSR ampEnv;
    private EnvelopeDAHDSR filterEnv;
    private Add cutoffAdder;
    private static MyVoiceDescription voiceDescription;
    public UnitInputPort amplitude;
    public UnitInputPort frequency;
    public UnitInputPort frequencyScaler;
    public UnitInputPort oscShape1;
    public UnitInputPort oscShape2;
    public UnitInputPort cutoff;
    public UnitInputPort filterEnvDepth;
    public UnitInputPort Q;
    private static final String[] presetNames;

    static {
        presetNames = new String[]{"FastSaw", "SlowSaw", "BrightSaw", "SoftSine", "SquareSaw", "SquareFifth", "Blip"};
    }

    public DualOscillatorSynthVoice() {
        this.add(this.frequencyMultiplier);
        this.amplitudeMultiplier = new Multiply();
        this.add(this.amplitudeMultiplier);
        this.amplitudeBoost = new Multiply();
        this.add(this.amplitudeBoost);
        this.detuneScaler1 = new Multiply();
        this.add(this.detuneScaler1);
        this.detuneScaler2 = new Multiply();
        this.add(this.detuneScaler2);
        this.osc1 = new MorphingOscillatorBL();
        this.add(this.osc1);
        this.osc2 = new MorphingOscillatorBL();
        this.add(this.osc2);
        this.ampEnv = new EnvelopeDAHDSR();
        this.add(this.ampEnv);
        this.filterEnv = new EnvelopeDAHDSR();
        this.add(this.filterEnv);
        this.filter = new FilterFourPoles();
        this.add(this.filter);
        this.cutoffAdder = new Add();
        this.add(this.cutoffAdder);
        this.filterEnv.output.connect(this.cutoffAdder.inputA);
        this.cutoffAdder.output.connect(this.filter.frequency);
        this.frequencyMultiplier.output.connect(this.detuneScaler1.inputA);
        this.frequencyMultiplier.output.connect(this.detuneScaler2.inputA);
        this.detuneScaler1.output.connect(this.osc1.frequency);
        this.detuneScaler2.output.connect(this.osc2.frequency);
        this.osc1.output.connect(this.amplitudeMultiplier.inputA);
        this.osc2.output.connect(this.amplitudeMultiplier.inputA);
        this.amplitudeMultiplier.output.connect(this.filter.input);
        this.filter.output.connect(this.amplitudeBoost.inputA);
        this.amplitudeBoost.output.connect(this.ampEnv.amplitude);
        this.amplitude = this.amplitudeMultiplier.inputB;
        this.addPort(this.amplitude, "Amplitude");
        this.frequency = this.frequencyMultiplier.inputA;
        this.addPort(this.frequency, "Frequency");
        this.oscShape1 = this.osc1.shape;
        this.addPort(this.oscShape1, "OscShape1");
        this.oscShape2 = this.osc2.shape;
        this.addPort(this.oscShape2, "OscShape2");
        this.cutoff = this.cutoffAdder.inputB;
        this.addPort(this.cutoff, "Cutoff");
        this.addPortAlias(this.cutoff, "Timbre");
        this.Q = this.filter.Q;
        this.addPort(this.Q);
        this.frequencyScaler = this.frequencyMultiplier.inputB;
        this.addPort(this.frequencyScaler, "FreqScaler");
        this.filterEnvDepth = this.filterEnv.amplitude;
        this.addPort(this.filterEnvDepth, "FilterEnvDepth");
        this.filterEnv.export(this, "Filter");
        this.ampEnv.export(this, "Amp");
        this.frequency.setup(this.osc1.frequency);
        this.frequencyScaler.setup(0.2, 1.0, 4.0);
        this.cutoff.setup(this.filter.frequency);
        this.filterEnvDepth.setup(-4000.0, 2000.0, 4000.0);
        this.osc1.amplitude.set(0.5);
        this.osc2.amplitude.set(0.4);
        this.ampEnv.setupAutoDisable(this);
        this.amplitudeBoost.inputB.setup(1.0, 1.0, 4.0);
        this.addPortAlias(this.amplitudeBoost.inputB, "Pressure");
        this.usePreset(0);
    }

    private void setDetunePitch(double semitoneOffset) {
        double halfOffset = semitoneOffset * 0.5;
        this.setDetunePitch1(halfOffset);
        this.setDetunePitch2(-halfOffset);
    }

    private void setDetunePitch1(double semitoneOffset) {
        double scale = AudioMath.semitonesToFrequencyScaler(semitoneOffset);
        this.detuneScaler1.inputB.set(scale);
    }

    private void setDetunePitch2(double semitoneOffset) {
        double scale = AudioMath.semitonesToFrequencyScaler(semitoneOffset);
        this.detuneScaler2.inputB.set(scale);
    }

    @Override
    public void noteOff(TimeStamp timeStamp) {
        this.ampEnv.input.off(timeStamp);
        this.filterEnv.input.off(timeStamp);
    }

    @Override
    public void noteOn(double freq, double ampl, TimeStamp timeStamp) {
        this.frequency.set(freq, timeStamp);
        this.amplitude.set(ampl, timeStamp);
        this.ampEnv.input.on(timeStamp);
        this.filterEnv.input.on(timeStamp);
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.ampEnv.output;
    }

    public void reset() {
        this.osc1.shape.set(0.0);
        this.osc2.shape.set(0.0);
        this.ampEnv.attack.set(0.005);
        this.ampEnv.decay.set(0.2);
        this.ampEnv.sustain.set(0.5);
        this.ampEnv.release.set(1.0);
        this.filterEnv.attack.set(0.01);
        this.filterEnv.decay.set(0.6);
        this.filterEnv.sustain.set(0.4);
        this.filterEnv.release.set(1.0);
        this.cutoff.set(500.0);
        this.filterEnvDepth.set(3000.0);
        this.filter.reset();
        this.filter.Q.set(3.9);
        this.setDetunePitch(0.02);
    }

    @Override
    public void usePreset(int presetIndex) {
        this.reset();
        int n = presetIndex % presetNames.length;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.ampEnv.attack.set(0.1);
                this.ampEnv.decay.set(0.9);
                this.ampEnv.sustain.set(0.1);
                this.ampEnv.release.set(0.1);
                this.cutoff.set(500.0);
                this.filterEnvDepth.set(500.0);
                this.filter.Q.set(3.0);
                break;
            }
            case 2: {
                this.ampEnv.attack.set(0.1);
                this.ampEnv.decay.set(0.3);
                this.ampEnv.release.set(0.5);
                this.cutoff.set(2000.0);
                this.filterEnvDepth.set(500.0);
                this.filter.Q.set(2.0);
                break;
            }
            case 3: {
                this.osc1.shape.set(-0.9);
                this.osc2.shape.set(-0.8);
                this.ampEnv.attack.set(0.3);
                this.ampEnv.decay.set(0.8);
                this.ampEnv.release.set(0.2);
                this.filterEnv.sustain.set(0.7);
                this.cutoff.set(500.0);
                this.filterEnvDepth.set(500.0);
                this.filter.Q.set(3.0);
                break;
            }
            case 4: {
                this.osc1.shape.set(1.0);
                this.osc2.shape.set(0.0);
                break;
            }
            case 5: {
                this.osc1.shape.set(1.0);
                this.setDetunePitch1(0.0);
                this.osc2.shape.set(0.9);
                this.setDetunePitch1(7.0);
                break;
            }
            case 6: {
                this.osc1.shape.set(0.6);
                this.osc2.shape.set(-0.2);
                this.setDetunePitch1(0.01);
                this.ampEnv.attack.set(0.005);
                this.ampEnv.decay.set(0.09);
                this.ampEnv.sustain.set(0.0);
                this.ampEnv.release.set(1.0);
                this.filterEnv.attack.set(0.005);
                this.filterEnv.decay.set(0.1);
                this.filterEnv.sustain.set(0.4);
                this.filterEnv.release.set(1.0);
                this.cutoff.set(2000.0);
                this.filterEnvDepth.set(5000.0);
                this.filter.Q.set(7.02);
                break;
            }
        }
    }

    public static VoiceDescription getVoiceDescription() {
        if (voiceDescription == null) {
            voiceDescription = new MyVoiceDescription();
        }
        return voiceDescription;
    }

    static class MyVoiceDescription
    extends VoiceDescription {
        String[] tags = new String[]{"electronic", "filter", "analog", "subtractive"};

        public MyVoiceDescription() {
            super(DualOscillatorSynthVoice.class.getName(), presetNames);
        }

        @Override
        public UnitVoice createUnitVoice() {
            return new DualOscillatorSynthVoice();
        }

        @Override
        public String[] getTags(int presetIndex) {
            return this.tags;
        }

        @Override
        public String getVoiceClassName() {
            return DualOscillatorSynthVoice.class.getName();
        }
    }
}

