/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.scope.AudioScope;
import com.jsyn.scope.TriggerModel;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.shared.time.ScheduledCommand;

public class MultiChannelScopeProbeUnit
extends UnitGenerator {
    public UnitInputPort input;
    public UnitInputPort trigger;
    private static final int STATE_IDLE = 0;
    private static final int STATE_ARMED = 1;
    private static final int STATE_READY = 2;
    private static final int STATE_TRIGGERED = 3;
    private int state = 0;
    private int numChannels;
    private double[][] inputValues;
    private static final int FRAMES_PER_BUFFER = 4096;
    private static final int FRAMES_PER_BUFFER_MASK = 4095;
    private Runnable callback;
    private TriggerModel triggerModel;
    private int autoCountdown;
    private int countdown;
    private int postTriggerSize = 512;
    SignalBuffer captureBuffer;
    SignalBuffer displayBuffer;

    public MultiChannelScopeProbeUnit(int numChannels, TriggerModel triggerModel) {
        this.numChannels = numChannels;
        this.captureBuffer = new SignalBuffer(numChannels);
        this.displayBuffer = new SignalBuffer(numChannels);
        this.triggerModel = triggerModel;
        this.trigger = new UnitInputPort(numChannels, "Trigger");
        this.addPort(this.trigger);
        this.input = new UnitInputPort(numChannels, "Input");
        this.addPort(this.input);
        this.inputValues = new double[numChannels][];
    }

    private synchronized void switchBuffers() {
        SignalBuffer temp = this.captureBuffer;
        this.captureBuffer = this.displayBuffer;
        this.displayBuffer = temp;
    }

    private void internalArm(Runnable callback) {
        this.callback = callback;
        this.state = 1;
        this.captureBuffer.reset();
    }

    public void arm(double time, Runnable callback) {
        ScheduledArm command = new ScheduledArm(callback);
        this.getSynthesisEngine().scheduleCommand(time, (ScheduledCommand)command);
    }

    @Override
    public void generate(int start, int limit) {
        if (this.state != 0) {
            AudioScope.TriggerMode triggerMode = this.triggerModel.getMode();
            double triggerLevel = this.triggerModel.getTriggerLevel();
            double[] triggerValues = this.trigger.getValues();
            int j = 0;
            while (j < this.numChannels) {
                this.inputValues[j] = this.input.getValues(j);
                ++j;
            }
            int i = start;
            while (i < limit) {
                int j2 = 0;
                while (j2 < this.numChannels) {
                    this.captureBuffer.saveChannelValue(j2, (float)this.inputValues[j2][i]);
                    ++j2;
                }
                this.captureBuffer.bumpCursor();
                switch (this.state) {
                    case 1: {
                        if (!(triggerValues[i] <= triggerLevel)) break;
                        this.state = 2;
                        this.autoCountdown = 44100;
                        break;
                    }
                    case 2: {
                        boolean triggered = false;
                        if (triggerValues[i] > triggerLevel) {
                            triggered = true;
                        } else if (triggerMode.equals((Object)AudioScope.TriggerMode.AUTO) && --this.autoCountdown == 0) {
                            triggered = true;
                        }
                        if (!triggered) break;
                        this.captureBuffer.markTrigger();
                        this.state = 3;
                        this.countdown = this.postTriggerSize;
                        break;
                    }
                    case 3: {
                        --this.countdown;
                        if (this.countdown > 0) break;
                        this.state = 0;
                        this.switchBuffers();
                        this.fireCallback();
                    }
                }
                ++i;
            }
        }
    }

    private void fireCallback() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public float getSample(int bufferIndex, int sampleIndex) {
        return this.displayBuffer.getSample(bufferIndex, sampleIndex);
    }

    public int getTriggerIndex() {
        return this.displayBuffer.getTriggerIndex();
    }

    public int getFramesCaptured() {
        return this.displayBuffer.getFramesCaptured();
    }

    public int getFramesPerBuffer() {
        return 4096;
    }

    public int getPostTriggerSize() {
        return this.postTriggerSize;
    }

    class ScheduledArm
    implements ScheduledCommand {
        private Runnable callback;

        ScheduledArm(Runnable callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            MultiChannelScopeProbeUnit.this.internalArm(this.callback);
        }
    }

    class SignalBuffer {
        float[][] buffers;
        private int writeCursor;
        private int triggerIndex;
        private int framesCaptured;

        SignalBuffer(int numChannels) {
            this.buffers = new float[numChannels][];
            int j = 0;
            while (j < numChannels) {
                this.buffers[j] = new float[4096];
                ++j;
            }
        }

        void reset() {
            this.writeCursor = 0;
            this.triggerIndex = 0;
            this.framesCaptured = 0;
        }

        public void saveChannelValue(int j, float value) {
            this.buffers[j][this.writeCursor] = value;
        }

        public void markTrigger() {
            this.triggerIndex = this.writeCursor;
        }

        public void bumpCursor() {
            this.writeCursor = this.writeCursor + 1 & 0xFFF;
            if (this.writeCursor >= 4096) {
                this.writeCursor = 0;
            }
            if (this.framesCaptured < 4096) {
                ++this.framesCaptured;
            }
        }

        private int convertInternalToExternalIndex(int internalIndex) {
            if (this.framesCaptured < 4096) {
                return internalIndex;
            }
            return internalIndex - this.writeCursor & 0xFFF;
        }

        private int convertExternalToInternalIndex(int externalIndex) {
            if (this.framesCaptured < 4096) {
                return externalIndex;
            }
            return externalIndex + this.writeCursor & 0xFFF;
        }

        public int getTriggerIndex() {
            return this.convertInternalToExternalIndex(this.triggerIndex);
        }

        public int getFramesCaptured() {
            return this.framesCaptured;
        }

        public float getSample(int bufferIndex, int sampleIndex) {
            int index = this.convertExternalToInternalIndex(sampleIndex);
            return this.buffers[bufferIndex][index];
        }
    }
}

