/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.TunableFilter;

public class FilterStateVariable
extends TunableFilter {
    public UnitInputPort amplitude;
    public UnitInputPort resonance;
    public UnitOutputPort lowPass;
    public UnitOutputPort bandPass;
    public UnitOutputPort highPass;
    private double freqInternal;
    private double previousFrequency = Double.MAX_VALUE;
    private double lowPassValue;
    private double bandPassValue;

    public FilterStateVariable() {
        this.frequency.set(440.0);
        this.resonance = new UnitInputPort("Resonance", 0.2);
        this.addPort(this.resonance);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.lowPass = new UnitOutputPort("LowPass");
        this.addPort(this.lowPass);
        this.bandPass = new UnitOutputPort("BandPass");
        this.addPort(this.bandPass);
        this.highPass = new UnitOutputPort("HighPass");
        this.addPort(this.highPass);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        double[] frequencies = this.frequency.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] reses = this.resonance.getValues();
        double[] lows = this.lowPass.getValues();
        double[] highs = this.highPass.getValues();
        double[] bands = this.bandPass.getValues();
        double newFreq = frequencies[0];
        if (newFreq != this.previousFrequency) {
            this.previousFrequency = newFreq;
            this.freqInternal = 2.0 * Math.sin(Math.PI * newFreq * this.getFramePeriod());
        }
        int i = start;
        while (i < limit) {
            double highPassValue;
            this.lowPassValue = this.freqInternal * this.bandPassValue + this.lowPassValue;
            lows[i] = this.lowPassValue = this.lowPassValue < -1.0 ? -1.0 : (this.lowPassValue > 1.0 ? 1.0 : this.lowPassValue);
            outputs[i] = this.lowPassValue * amplitudes[i];
            highs[i] = highPassValue = inputs[i] - reses[i] * this.bandPassValue - this.lowPassValue;
            bands[i] = this.bandPassValue = this.freqInternal * highPassValue + this.bandPassValue;
            ++i;
        }
    }
}

