/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSink;
import com.jsyn.unitgen.UnitSource;

public class MultiPassThrough
extends UnitGenerator
implements UnitSink,
UnitSource {
    public UnitInputPort input;
    public UnitOutputPort output;
    private int mNumParts;

    public MultiPassThrough(int numParts) {
        this.mNumParts = numParts;
        this.input = new UnitInputPort(numParts, "Input");
        this.addPort(this.input);
        this.output = new UnitOutputPort(numParts, "Output");
        this.addPort(this.output);
    }

    public MultiPassThrough() {
        this(2);
    }

    @Override
    public UnitInputPort getInput() {
        return this.input;
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }

    @Override
    public void generate(int start, int limit) {
        int partIndex = 0;
        while (partIndex < this.mNumParts) {
            double[] inputs = this.input.getValues(partIndex);
            double[] outputs = this.output.getValues(partIndex);
            int i = start;
            while (i < limit) {
                outputs[i] = inputs[i];
                ++i;
            }
            ++partIndex;
        }
    }
}

