/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.Compare;
import com.jsyn.unitgen.Divide;
import com.jsyn.unitgen.Maximum;
import com.jsyn.unitgen.Minimum;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.MultiplyAdd;
import com.jsyn.unitgen.PitchToFrequency;
import com.jsyn.unitgen.PowerOfTwo;
import com.jsyn.unitgen.Subtract;
import com.jsyn.unitgen.UnitBinaryOperator;
import com.softsynth.math.AudioMath;
import junit.framework.TestCase;

public class TestMath
extends TestCase {
    SynthesisEngine synthesisEngine;

    protected void setUp() throws Exception {
        super.setUp();
        this.synthesisEngine = new SynthesisEngine();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAdd() {
        Add add = new Add();
        add.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        add.inputA.setValueInternal(x);
        add.inputB.setValueInternal(y);
        add.generate();
        TestMath.assertEquals((String)"Add", (double)(x + y), (double)add.output.getValue(), (double)0.001);
    }

    public void testPartialAdd() {
        Add add = new Add();
        add.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        add.inputA.setValueInternal(x);
        add.inputB.setValueInternal(y);
        add.generate(2, 5);
        TestMath.assertEquals((String)"Add partial", (double)0.0, (double)add.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"Add partial", (double)0.0, (double)add.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"Add partial", (double)(x + y), (double)add.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"Add partial", (double)(x + y), (double)add.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"Add partial", (double)(x + y), (double)add.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"Add partial", (double)0.0, (double)add.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"Add partial", (double)0.0, (double)add.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"Add partial", (double)0.0, (double)add.output.getValues()[7], (double)0.001);
    }

    public void testSubtract() {
        Subtract sub = new Subtract();
        sub.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        sub.inputA.setValueInternal(x);
        sub.inputB.setValueInternal(y);
        sub.generate();
        TestMath.assertEquals((String)"Subtract", (double)(x - y), (double)sub.output.getValue(), (double)0.001);
    }

    public void testPartialSubtract() {
        Subtract sub = new Subtract();
        sub.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        sub.inputA.setValueInternal(x);
        sub.inputB.setValueInternal(y);
        sub.generate(2, 5);
        TestMath.assertEquals((String)"Subtract partial", (double)0.0, (double)sub.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"Subtract partial", (double)0.0, (double)sub.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"Subtract partial", (double)(x - y), (double)sub.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"Subtract partial", (double)(x - y), (double)sub.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"Subtract partial", (double)(x - y), (double)sub.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"Subtract partial", (double)0.0, (double)sub.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"Subtract partial", (double)0.0, (double)sub.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"Subtract partial", (double)0.0, (double)sub.output.getValues()[7], (double)0.001);
    }

    public void testMultiply() {
        Multiply mult = new Multiply();
        mult.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        mult.inputA.setValueInternal(x);
        mult.inputB.setValueInternal(y);
        mult.generate();
        TestMath.assertEquals((String)"Multiply", (double)(x * y), (double)mult.output.getValue(), (double)0.001);
    }

    public void testPartialMultiply() {
        Multiply mult = new Multiply();
        mult.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        mult.inputA.setValueInternal(x);
        mult.inputB.setValueInternal(y);
        mult.generate(2, 5);
        TestMath.assertEquals((String)"Multiply partial", (double)0.0, (double)mult.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"Multiply partial", (double)0.0, (double)mult.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"Multiply partial", (double)(x * y), (double)mult.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"Multiply partial", (double)(x * y), (double)mult.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"Multiply partial", (double)(x * y), (double)mult.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"Multiply partial", (double)0.0, (double)mult.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"Multiply partial", (double)0.0, (double)mult.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"Multiply partial", (double)0.0, (double)mult.output.getValues()[7], (double)0.001);
    }

    public void testDivide() {
        Divide divide = new Divide();
        divide.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        divide.inputA.setValueInternal(x);
        divide.inputB.setValueInternal(y);
        divide.generate();
        TestMath.assertEquals((String)"Divide", (double)(x / y), (double)divide.output.getValue(), (double)0.001);
    }

    public void testPartialDivide() {
        Divide divide = new Divide();
        divide.setSynthesisEngine(this.synthesisEngine);
        double x = 2.5;
        double y = 9.7;
        divide.inputA.setValueInternal(x);
        divide.inputB.setValueInternal(y);
        divide.generate(2, 5);
        TestMath.assertEquals((String)"Divide partial", (double)0.0, (double)divide.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"Divide partial", (double)0.0, (double)divide.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"Divide partial", (double)(x / y), (double)divide.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"Divide partial", (double)(x / y), (double)divide.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"Divide partial", (double)(x / y), (double)divide.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"Divide partial", (double)0.0, (double)divide.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"Divide partial", (double)0.0, (double)divide.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"Divide partial", (double)0.0, (double)divide.output.getValues()[7], (double)0.001);
    }

    public void testMultiplyAdd() {
        MultiplyAdd multAdd = new MultiplyAdd();
        multAdd.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        double z = 2.28;
        multAdd.inputA.setValueInternal(x);
        multAdd.inputB.setValueInternal(y);
        multAdd.inputC.setValueInternal(z);
        multAdd.generate();
        TestMath.assertEquals((String)"MultiplyAdd", (double)(x * y + z), (double)multAdd.output.getValue(), (double)0.001);
    }

    public void testPartialMultiplyAdd() {
        MultiplyAdd multAdd = new MultiplyAdd();
        multAdd.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        double z = 2.28;
        multAdd.inputA.setValueInternal(x);
        multAdd.inputB.setValueInternal(y);
        multAdd.inputC.setValueInternal(z);
        multAdd.generate(2, 5);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)0.0, (double)multAdd.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)0.0, (double)multAdd.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)(x * y + z), (double)multAdd.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)(x * y + z), (double)multAdd.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)(x * y + z), (double)multAdd.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)0.0, (double)multAdd.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)0.0, (double)multAdd.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"MultiplyAdd partial", (double)0.0, (double)multAdd.output.getValues()[7], (double)0.001);
    }

    public void testCompare() {
        Compare compare = new Compare();
        compare.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        compare.inputA.setValueInternal(x);
        compare.inputB.setValueInternal(y);
        compare.generate();
        TestMath.assertEquals((String)"Compare", (double)(x > y ? 1 : 0), (double)compare.output.getValue(), (double)0.001);
    }

    public void testPartialCompare() {
        Compare compare = new Compare();
        compare.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        compare.inputA.setValueInternal(x);
        compare.inputB.setValueInternal(y);
        ((UnitBinaryOperator)compare).generate(2, 5);
        TestMath.assertEquals((String)"Compare partial", (double)0.0, (double)compare.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"Compare partial", (double)0.0, (double)compare.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"Compare partial", (double)(x > y ? 1 : 0), (double)compare.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"Compare partial", (double)(x > y ? 1 : 0), (double)compare.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"Compare partial", (double)(x > y ? 1 : 0), (double)compare.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"Compare partial", (double)0.0, (double)compare.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"Compare partial", (double)0.0, (double)compare.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"Compare partial", (double)0.0, (double)compare.output.getValues()[7], (double)0.001);
    }

    public void testMaximum() {
        Maximum max = new Maximum();
        max.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        max.inputA.setValueInternal(x);
        max.inputB.setValueInternal(y);
        max.generate();
        TestMath.assertEquals((String)"Maximum", (double)(x > y ? x : y), (double)max.output.getValue(), (double)0.001);
    }

    public void testPartialMaximum() {
        Maximum max = new Maximum();
        max.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        max.inputA.setValueInternal(x);
        max.inputB.setValueInternal(y);
        max.generate(2, 5);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)max.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)max.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)(x > y ? x : y), (double)max.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)(x > y ? x : y), (double)max.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)(x > y ? x : y), (double)max.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)max.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)max.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)max.output.getValues()[7], (double)0.001);
    }

    public void testMinimum() {
        Minimum min = new Minimum();
        min.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        min.inputA.setValueInternal(x);
        min.inputB.setValueInternal(y);
        min.generate();
        TestMath.assertEquals((String)"Minimum", (double)(x < y ? x : y), (double)min.output.getValue(), (double)0.001);
    }

    public void testPartialMinimum() {
        Minimum min = new Minimum();
        min.setSynthesisEngine(this.synthesisEngine);
        double x = 33.99;
        double y = 8.31;
        min.inputA.setValueInternal(x);
        min.inputB.setValueInternal(y);
        min.generate(2, 5);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)min.output.getValues()[0], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)min.output.getValues()[1], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)(x < y ? x : y), (double)min.output.getValues()[2], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)(x < y ? x : y), (double)min.output.getValues()[3], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)(x < y ? x : y), (double)min.output.getValues()[4], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)min.output.getValues()[5], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)min.output.getValues()[6], (double)0.001);
        TestMath.assertEquals((String)"Maximum partial", (double)0.0, (double)min.output.getValues()[7], (double)0.001);
    }

    public void testPowerOfTwo() {
        double[] values;
        PowerOfTwo powerOfTwo = new PowerOfTwo();
        powerOfTwo.setSynthesisEngine(this.synthesisEngine);
        double smallValue = -1.5308084989341915E-17;
        double[] dArray = values = new double[]{0.0, 1.3, 4.5, -0.5, -1.0, -2.8, -1.5308084989341915E-17, 1.5308084989341915E-17, 1.0, 1.0};
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double in = dArray[n2];
            powerOfTwo.input.setValueInternal(in);
            powerOfTwo.generate();
            TestMath.assertEquals((String)"PowerOfTwo", (double)Math.pow(2.0, in), (double)powerOfTwo.output.getValue(), (double)0.001);
            ++n2;
        }
    }

    public void testPitchToFrequency() {
        PitchToFrequency ugen = new PitchToFrequency();
        ugen.setSynthesisEngine(this.synthesisEngine);
        double smallValue = -1.5308084989341915E-17;
        double[] values = new double[]{49.0, 49.5, 50.0, 60.0, 79.2, 12.9, 118.973};
        TestMath.assertEquals((String)"PitchToFrequency", (double)440.0, (double)AudioMath.pitchToFrequency(69.0), (double)0.001);
        TestMath.assertEquals((String)"PitchToFrequency", (double)660.0, (double)AudioMath.pitchToFrequency(76.02), (double)0.1);
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double pitch = dArray[n2];
            ugen.input.setValueInternal(pitch);
            ugen.generate();
            TestMath.assertEquals((String)"PitchToFrequency", (double)AudioMath.pitchToFrequency(pitch), (double)ugen.output.getValue(), (double)0.001);
            ++n2;
        }
    }
}

