/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.util.SignalCorrelator;

public class AutoCorrelator
implements SignalCorrelator {
    private static final float SUB_OCTAVE_REJECTION_FACTOR = 5.0E-4f;
    private static final int STATE_SEEKING_NEGATIVE = 0;
    private static final int STATE_SEEKING_POSITIVE = 1;
    private static final int STATE_SEEKING_MAXIMUM = 2;
    private static final int[] tauAdvanceByState = new int[]{4, 2, 1};
    private int state;
    private float[] buffer;
    private float[] diffs;
    private float[] diffs1;
    private float[] diffs2;
    private int cursor = -1;
    private int tau;
    private float sumProducts;
    private float sumSquares;
    private float localMaximum;
    private int localPosition;
    private float bestMaximum;
    private int bestPosition;
    private int peakCounter;
    private float pitchCorrectionFactor = 0.99988f;
    private double period;
    private double confidence;
    private int minPeriod = 2;
    private boolean bufferValid;
    private double previousSample = 0.0;
    private int maxWindowSize;
    private float noiseThreshold = 0.001f;

    public AutoCorrelator(int numFrames) {
        this.buffer = new float[numFrames];
        this.maxWindowSize = this.buffer.length / 2;
        this.diffs1 = new float[2 + numFrames / 2];
        this.diffs2 = new float[this.diffs1.length];
        this.diffs = this.diffs1;
        this.period = this.minPeriod;
        this.reset();
    }

    private void rawDeltaScan(int last1, int last2, int count, int stride) {
        int k = 0;
        while (k < count) {
            float d1 = this.buffer[last1 - k];
            float d2 = this.buffer[last2 - k];
            this.sumProducts += d1 * d2;
            this.sumSquares += d1 * d1 + d2 * d2;
            k += stride;
        }
    }

    private void splitDeltaScan(int last1, int splitLast, int count, int stride) {
        int c1 = splitLast;
        this.rawDeltaScan(last1, splitLast, c1, stride);
        this.rawDeltaScan(last1 - c1, this.buffer.length - 1, count - c1, stride);
    }

    private void checkDeltaScan(int last1, int last2, int count, int stride) {
        if (count > last2) {
            int c1 = last2;
            this.checkDeltaScan(last2, last1, c1, stride);
            this.checkDeltaScan(this.buffer.length - 1, last1 - c1, count - c1, stride);
        } else if (count > last1) {
            this.splitDeltaScan(last2, last1, count, stride);
        } else {
            this.rawDeltaScan(last1, last2, count, stride);
        }
    }

    private float topScan(int last1, int tau, int count, int stride) {
        float minimumResult = 1.0E-8f;
        int last2 = last1 - tau;
        if (last2 < 0) {
            last2 += this.buffer.length;
        }
        this.sumProducts = 0.0f;
        this.sumSquares = 0.0f;
        this.checkDeltaScan(last1, last2, count, stride);
        if (this.sumSquares < 1.0E-8f) {
            return 1.0E-8f;
        }
        float correction = (float)Math.pow(this.pitchCorrectionFactor, tau);
        float result = (float)(2.0 * (double)this.sumProducts / (double)this.sumSquares) * correction;
        return result;
    }

    private void reset() {
        this.switchDiffs();
        int i = 0;
        while (i < this.minPeriod) {
            this.diffs[i] = 1.0f;
            ++i;
        }
        while (i < this.diffs.length) {
            this.diffs[i] = 0.0f;
            ++i;
        }
        this.tau = this.minPeriod;
        this.state = 0;
        this.peakCounter = 0;
        this.bestMaximum = -1.0f;
        this.bestPosition = -1;
    }

    private void nextPeakAnalysis(int index) {
        float value = this.diffs[index] * (1.0f - (float)index * 5.0E-4f);
        switch (this.state) {
            case 0: {
                if (!(value < -0.01f)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (!(value > 0.2f)) break;
                this.state = 2;
                this.localMaximum = value;
                this.localPosition = index;
                break;
            }
            case 2: {
                if (value > this.localMaximum) {
                    this.localMaximum = value;
                    this.localPosition = index;
                    break;
                }
                if (!(value < -0.1f)) break;
                ++this.peakCounter;
                if (this.localMaximum > this.bestMaximum) {
                    this.bestMaximum = this.localMaximum;
                    this.bestPosition = this.localPosition;
                }
                this.state = 1;
            }
        }
    }

    private double findPreciseMaximum(int indexMax) {
        if (indexMax < 3) {
            return 3.0;
        }
        if (indexMax == this.diffs.length - 1) {
            return indexMax;
        }
        double d1 = this.diffs[indexMax - 1];
        double d2 = this.diffs[indexMax];
        double d3 = this.diffs[indexMax + 1];
        return AutoCorrelator.interpolatePeak(d1, d2, d3) + (double)indexMax;
    }

    protected static double interpolatePeak(double d1, double d2, double d3) {
        return 0.5 * (d1 - d3) / (d1 - 2.0 * d2 + d3);
    }

    private boolean incrementalAnalysis() {
        boolean updated = false;
        if (this.bufferValid) {
            int windowSize = (int)((double)this.tau * this.confidence + (double)this.maxWindowSize * (1.0 - this.confidence));
            int stride = 1;
            this.diffs[this.tau] = this.topScan(this.cursor, this.tau, windowSize, stride);
            if (this.tau == this.minPeriod && this.sumProducts < this.noiseThreshold) {
                boolean result = this.confidence > 0.0;
                this.confidence = 0.0;
                return result;
            }
            this.nextPeakAnalysis(this.tau);
            ++this.tau;
            int advance = tauAdvanceByState[this.state] - 1;
            while (advance > 0 && this.tau < this.diffs.length) {
                this.diffs[this.tau] = this.diffs[this.tau - 1];
                ++this.tau;
                --advance;
            }
            if (this.peakCounter >= 4 || this.tau >= this.maxWindowSize) {
                if ((double)this.bestMaximum > 0.0) {
                    this.period = this.findPreciseMaximum(this.bestPosition);
                    this.confidence = (double)this.bestMaximum < 0.0 ? 0.0 : (double)this.bestMaximum;
                } else {
                    this.confidence = 0.0;
                }
                updated = true;
                this.reset();
            }
        }
        return updated;
    }

    @Override
    public float[] getDiffs() {
        return this.diffs == this.diffs1 ? this.diffs2 : this.diffs1;
    }

    private void switchDiffs() {
        this.diffs = this.diffs == this.diffs1 ? this.diffs2 : this.diffs1;
    }

    @Override
    public boolean addSample(double value) {
        double average = (value + this.previousSample) * 0.5;
        this.previousSample = value;
        ++this.cursor;
        if (this.cursor == this.buffer.length) {
            this.cursor = 0;
            this.bufferValid = true;
        }
        this.buffer[this.cursor] = (float)average;
        return this.incrementalAnalysis();
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    @Override
    public double getConfidence() {
        return this.confidence;
    }

    public float getPitchCorrectionFactor() {
        return this.pitchCorrectionFactor;
    }

    public void setPitchCorrectionFactor(float pitchCorrectionFactor) {
        this.pitchCorrectionFactor = pitchCorrectionFactor;
    }
}

