/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.compose;

import java.util.Arrays;

public class Scale {
    private static final int[] major;
    private static final int[] naturalMinor;
    private static final int[] harmonicMinor;
    private int[] gamut;
    private int tonic;
    private int octaveSize = 12;
    private String name;

    static {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        major = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 5;
        nArray2[4] = 7;
        nArray2[5] = 8;
        nArray2[6] = 10;
        naturalMinor = nArray2;
        int[] nArray3 = new int[7];
        nArray3[1] = 2;
        nArray3[2] = 3;
        nArray3[3] = 5;
        nArray3[4] = 7;
        nArray3[5] = 8;
        nArray3[6] = 11;
        harmonicMinor = nArray3;
    }

    public Scale(int[] gamut, int tonic) {
        this.gamut = gamut;
        this.tonic = tonic;
    }

    public Scale(int[] gamut, int tonic, String name) {
        this(gamut, tonic);
        this.name = name;
    }

    public String toString() {
        return this.name == null ? "unknown" : this.name;
    }

    public static Scale createMajorScale(int tonic) {
        return new Scale(major, tonic, "Major");
    }

    public static Scale createHarmonicMinorScale(int tonic) {
        return new Scale(harmonicMinor, tonic, "HarmonicMinor");
    }

    public static Scale createNaturalMinorScale(int tonic) {
        return new Scale(naturalMinor, tonic, "NaturalMinor");
    }

    public Scale createTriad(int index) {
        int[] notesInChord = new int[3];
        int i = 0;
        notesInChord[i++] = this.gamut[index % this.gamut.length];
        notesInChord[i++] = this.gamut[(index + 2) % this.gamut.length];
        notesInChord[i++] = this.gamut[(index + 4) % this.gamut.length];
        Arrays.sort(notesInChord);
        return new Scale(notesInChord, this.tonic);
    }

    public int get(int index) {
        int octave = index / this.gamut.length;
        int degree = index - octave * this.gamut.length;
        int octaveOffset = octave * this.octaveSize;
        return this.tonic + octaveOffset + this.gamut[degree];
    }

    public int getTonic() {
        return this.tonic;
    }

    public void setTonic(int tonic) {
        this.tonic = tonic;
    }

    public int getOctaveSize() {
        return this.octaveSize;
    }

    public void setOctaveSize(int octaveSize) {
        this.octaveSize = octaveSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int size() {
        return this.gamut.length;
    }
}

