/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.jsyn.swing.RotaryController;
import com.syntona.gui.patch.BitMaskJackView;
import com.syntona.gui.patch.JackInABox;
import com.syntona.gui.patch.JackPartner;
import com.syntona.gui.patch.LabelledCanvas;
import com.syntona.gui.patch.ModulePartner;
import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.gui.patch.PatchGlobals;
import com.syntona.gui.patch.SafeRotaryController;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.InputBitMaskJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaModel;
import com.syntona.plugin.SyntonaModelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GenericModuleView
extends ModuleView {
    private static final int JACK_COMP_HEIGHT = 20;
    private static final int JACK_COMP_WIDTH = 80;
    private static final int KNOB_HEIGHT = 30;
    private static final int KNOB_WIDTH = 30;
    private LabelledCanvas header;
    private HashMap<Jack, JComponent> mJackViews = new HashMap();

    public GenericModuleView(ModulePresenter presenter) {
        super(presenter);
    }

    public GenericModuleView() {
    }

    @Override
    public LayoutManager makeLayout() {
        return new BoxLayout(this, 1);
    }

    @Override
    public void makeJacks() {
        Jack[] jacks;
        Jack[] jackArray = jacks = this.getModule().getJacks();
        int n = jacks.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            this.addJack(jack);
            ++n2;
        }
        this.validate();
        int height = 0;
        int width = 80;
        Component[] componentArray = this.getComponents();
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Component comp = componentArray[n4];
            height = (int)((double)height + comp.getPreferredSize().getHeight());
            int compWidth = (int)comp.getPreferredSize().getWidth();
            if (width < compWidth) {
                width = compWidth;
            }
            ++n4;
        }
        this.setSize(width + 16, height + 8);
    }

    protected JComponent getJackView(Jack jack) {
        return this.mJackViews.get(jack);
    }

    private JComponent createJackView(Jack jack) {
        JComponent inside = null;
        if (jack.isVisible()) {
            int viewType = jack.getViewType();
            switch (viewType) {
                case 1: {
                    inside = this.createActionJackView(jack);
                    new JackPartner(inside, this.getPresenter(), jack);
                    break;
                }
                case 2: {
                    inside = this.createKnobView((InputDoubleJack)jack);
                    break;
                }
                case 3: {
                    inside = this.createGridView((InputBitMaskJack)jack);
                    new JackPartner(inside, this.getPresenter(), jack);
                    break;
                }
                default: {
                    inside = this.createBasicJackView(jack);
                    new JackPartner(inside, this.getPresenter(), jack);
                }
            }
            this.mJackViews.put(jack, inside);
            this.setupPatchComponent(inside);
        }
        JPanel plug = null;
        if (jack.isConnectable()) {
            plug = this.createJackBox(jack);
            this.setupPatchComponent(plug);
        }
        JPanel wrapper = null;
        Jack levelWithJack = jack.getLevelWith();
        if (levelWithJack == null) {
            wrapper = new JPanel();
            wrapper.setLayout(new BoxLayout(wrapper, 0));
            if (plug != null && !jack.isOutput()) {
                wrapper.add(plug);
            } else {
                wrapper.add(Box.createRigidArea(new Dimension(8, 0)));
            }
            if (inside != null) {
                wrapper.add(inside);
            }
            if (plug != null && jack.isOutput()) {
                wrapper.add(plug);
            } else {
                wrapper.add(Box.createRigidArea(new Dimension(8, 0)));
            }
            Color color = jack.getColor();
            wrapper.setBackground(color);
        } else if (plug != null) {
            JackPartner partner = levelWithJack.getPartner();
            JComponent component = partner.getComponent();
            wrapper = (JPanel)component.getParent();
            if (!jack.isOutput()) {
                wrapper.remove(0);
                wrapper.add((Component)plug, 0);
            } else {
                wrapper.remove(wrapper.getComponentCount() - 1);
                wrapper.add(plug);
            }
            wrapper = null;
        }
        return wrapper;
    }

    private JComponent createGridView(InputBitMaskJack jack) {
        BitMaskJackView jackView = new BitMaskJackView(jack);
        this.addComponent(jackView);
        return jackView;
    }

    private JComponent createKnobView(final InputDoubleJack jack) {
        BoundedRangeModel rangeModel = jack.getBoundedRangeModel();
        Insets insets = this.getInsets();
        final SafeRotaryController knob = new SafeRotaryController(rangeModel);
        final Color offColor = knob.getBackground();
        final Color onColor = new Color(180, 130, 80);
        knob.setStyle(RotaryController.Style.ARC);
        knob.setSize(30, 30);
        knob.setLocation(insets.left + 8, insets.top + 10);
        jack.addModelListener(new SyntonaModelListener(){

            @Override
            public void nameChanged(SyntonaModel syntonaModel) {
            }

            @Override
            public void onOffChanged(SyntonaModel syntonaModel, boolean onOrOff) {
                if (PatchFrame.isOnTop(jack.getPartner().getComponent())) {
                    knob.setBackground(onOrOff ? onColor : offColor);
                }
            }

            @Override
            public void indexChanged(SyntonaModel syntonaModel, int index) {
            }
        });
        this.addComponent(knob);
        return knob;
    }

    private JComponent createBasicJackView(final Jack jack) {
        final JackInABox comp = new JackInABox(jack);
        if (jack.isOutput()) {
            comp.setAlignment(4);
        }
        this.setJackViewSizes(comp);
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                comp.incrementForceValueDisplay();
                comp.updateText();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                comp.decrementForceValueDisplay();
                comp.updateText();
            }
        });
        jack.addModelListener(new SyntonaModelListener(){

            @Override
            public void nameChanged(SyntonaModel syntonaModel) {
                comp.showDefaultText();
            }

            @Override
            public void onOffChanged(SyntonaModel syntonaModel, boolean onOrOff) {
                if (PatchFrame.isOnTop(jack.getPartner().getComponent())) {
                    comp.setOn(onOrOff);
                }
            }

            @Override
            public void indexChanged(SyntonaModel syntonaModel, int index) {
            }
        });
        return comp;
    }

    private void setJackViewSizes(Component comp) {
        Dimension dimension = new Dimension(64, 20);
        comp.setMinimumSize(dimension);
        comp.setPreferredSize(dimension);
        comp.setMaximumSize(dimension);
    }

    private JComponent createActionJackView(final Jack jack) {
        JButton button = new JButton(jack.getName());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((InputActionJack)jack).execute();
            }
        });
        this.setJackViewSizes(button);
        this.addComponent(button);
        return button;
    }

    @Override
    public void addJack(Jack jack) {
        if (!this.containsJack(jack)) {
            super.addJack(jack);
            JComponent comp = this.createJackView(jack);
            if (comp != null) {
                this.addComponent(comp);
            }
        }
    }

    @Override
    public JComponent makeHeader() {
        String name = this.getModule().getName();
        this.header = new LabelledCanvas(name);
        this.header.setBackground(PatchGlobals.getHeaderColor());
        new ModulePartner(this.header, this.getPresenter());
        Dimension dimension = new Dimension(80, 20);
        this.header.setMinimumSize(dimension);
        this.header.setPreferredSize(dimension);
        this.header.setMaximumSize(dimension);
        this.addComponent(this.header, null, 0);
        this.header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                GenericModuleView.this.header.setText(GenericModuleView.this.getModule().getType());
            }

            @Override
            public void mouseExited(MouseEvent me) {
                GenericModuleView.this.header.setText(GenericModuleView.this.getModule().getName());
            }
        });
        return this.header;
    }

    @Override
    public void updateName() {
        this.header.setText(this.getModule().getName());
    }
}

