/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.model.SyntonaCommand;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;
import com.syntona.plugin.WireTime;

public class CounterModule
extends SyntonaModule {
    private int counter;
    private OutputDoubleJack output;

    public CounterModule() {
        super("Increment by one.");
        new InputActionJack(this, "reset", "reset counter back to zero"){

            @Override
            public void execute(PatchMessage msg) {
                CounterModule.this.counter = 0;
                CounterModule counterModule = CounterModule.this;
                int n = counterModule.counter;
                counterModule.counter = n + 1;
                CounterModule.this.passDoubleMessage(n, CounterModule.this.output);
            }

            @Override
            public void execute() {
                CounterModule.this.counter = 0;
                CounterModule.this.scheduleNextTick(new WireTime());
            }
        };
        new InputActionJack(this, "inc", "increment counter"){

            @Override
            public void execute(PatchMessage msg) {
                CounterModule counterModule = CounterModule.this;
                int n = counterModule.counter;
                counterModule.counter = n + 1;
                CounterModule.this.passDoubleMessage(n, CounterModule.this.output);
            }

            @Override
            public void execute() {
                CounterModule.this.scheduleNextTick(new WireTime());
            }
        };
        this.output = new OutputDoubleJack(this, "out");
    }

    public void scheduleNextTick(WireTime time) {
        CounterCommand cmd = new CounterCommand();
        this.getEngine().send(time, cmd);
    }

    private class CounterCommand
    implements SyntonaCommand {
        private CounterCommand() {
        }

        @Override
        public void execute() {
            CounterModule counterModule = CounterModule.this;
            int n = counterModule.counter;
            counterModule.counter = n + 1;
            CounterModule.this.passDoubleMessage(n, CounterModule.this.output);
        }

        @Override
        public void undo() {
        }
    }
}

