/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.compose.swing.BasicScoreInstrument;
import com.softsynth.math.AudioMath;
import com.softsynth.score.JSynScoreClock;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.SyntonaModule;

public class NotePlayerModel
extends SyntonaModule {
    private VoiceAllocator allocator;
    static final int MAX_NOTES = 8;
    private InputDoubleJack indexJack = new InputDoubleJack(this, "index");
    private InputDoubleJack pitchJack = new InputDoubleJack(this, "pitch");
    private InputDoubleJack velocityJack;
    private OutputAudioJack outputJack;
    private Synthesizer synth;
    private PassThrough mixer;
    private BasicScoreInstrument instrument;
    private SubtractiveSynthVoice[] voices;
    private JSynScoreClock clock;

    public NotePlayerModel() {
        super("Play the note.");
        this.pitchJack.setValue(0.0);
        this.velocityJack = new InputDoubleJack(this, "velocity");
        this.indexJack.setKickable(true);
        this.synth = JSynBundle.getSynthesizer();
        this.mixer = new PassThrough();
        this.synth.add(this.mixer);
        this.outputJack = new OutputAudioJack((SyntonaModule)this, "output", this.mixer.output);
        this.voices = new SubtractiveSynthVoice[8];
        int i = 0;
        while (i < 8) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(this.mixer.input);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.clock = new JSynScoreClock(this.synth);
        this.instrument = new BasicScoreInstrument(this.clock, this.allocator);
    }

    @Override
    public void kick() {
        byte noteIndex = (byte)Math.round(this.indexJack.getValue());
        double pitch = this.pitchJack.getValue();
        double amplitude = this.velocityJack.getValue() / 128.0;
        System.out.println("notePlayer: noteIndex = " + noteIndex);
        System.out.println("notePlayer: pitch = " + pitch);
        if (pitch == 0.0) {
            pitch = noteIndex;
        }
        double frequency = AudioMath.pitchToFrequency(pitch);
        System.out.println("notePlayer: frequency = " + frequency);
        System.out.println("notePlayer: amplitude = " + amplitude);
        if (amplitude > 1.0E-5) {
            this.instrument.noteOn(noteIndex, frequency, amplitude, this.clock.getScoreTime());
        } else {
            this.instrument.noteOff(noteIndex, frequency, amplitude, this.clock.getScoreTime());
        }
    }
}

