/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.unitgen.ChannelIn;
import com.jsyn.unitgen.ChannelOut;
import com.jsyn.unitgen.FixedRateMonoReader;
import com.jsyn.unitgen.FixedRateMonoWriter;
import com.jsyn.unitgen.Maximum;
import com.jsyn.unitgen.Minimum;
import com.jsyn.util.WaveFileWriter;
import java.io.File;
import java.io.IOException;

public class LongEcho {
    static final int DELAY_SECONDS = 4;
    Synthesizer synth;
    ChannelIn channelIn;
    ChannelOut channelOut;
    FloatSample sample;
    FixedRateMonoReader reader;
    FixedRateMonoWriter writer;
    Minimum minner;
    Maximum maxxer;

    private void test() throws IOException {
        this.synth = JSyn.createSynthesizer();
        this.channelIn = new ChannelIn();
        this.synth.add(this.channelIn);
        this.channelOut = new ChannelOut();
        this.synth.add(this.channelOut);
        this.minner = new Minimum();
        this.synth.add(this.minner);
        this.maxxer = new Maximum();
        this.synth.add(this.maxxer);
        this.reader = new FixedRateMonoReader();
        this.synth.add(this.reader);
        this.writer = new FixedRateMonoWriter();
        this.synth.add(this.writer);
        this.sample = new FloatSample(176400, 1);
        this.maxxer.inputB.set(-0.98);
        this.minner.inputB.set(0.98);
        this.channelIn.output.connect(this.minner.inputA);
        this.minner.output.connect(this.maxxer.inputA);
        this.maxxer.output.connect(this.writer.input);
        this.reader.output.connect(this.channelOut.input);
        int numInputChannels = 2;
        int numOutputChannels = 2;
        this.synth.start(44100, -1, numInputChannels, -1, numOutputChannels);
        this.writer.start();
        this.channelOut.start();
        this.reader.dataQueue.queue(this.sample, 1000, this.sample.getNumFrames() - 1000);
        this.reader.dataQueue.queueLoop(this.sample, 0, this.sample.getNumFrames());
        this.writer.dataQueue.queueLoop(this.sample, 0, this.sample.getNumFrames());
        System.out.println("Start talking. You should hear an echo after 4 seconds.");
        try {
            double time = this.synth.getCurrentTime();
            this.synth.sleepUntil(time + 30.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.saveEcho(new File("saved_echo.wav"));
        this.synth.stop();
    }

    private void saveEcho(File file) throws IOException {
        WaveFileWriter writer = new WaveFileWriter(file);
        writer.setFrameRate(44100);
        writer.setSamplesPerFrame(1);
        writer.setBitsPerSample(16);
        float[] buffer = new float[this.sample.getNumFrames()];
        this.sample.read(buffer);
        float[] fArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            writer.write(v);
            ++n2;
        }
        writer.close();
    }

    public static void main(String[] args) {
        try {
            new LongEcho().test();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

