/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;

public class PlayPartials {
    private Synthesizer synth;
    private UnitOscillator[] osc;
    private Multiply[] multipliers;
    private LinearRamp ramp;
    private LineOut lineOut;
    private double[] amps = new double[]{0.2, 0.1, 0.3, 0.4};
    private double[] ratios = new double[]{1.0, Math.sqrt(2.0), Math.E, Math.PI};

    private void test() {
        this.synth = JSyn.createSynthesizer();
        this.synth.start();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.ramp = new LinearRamp();
        this.synth.add(this.ramp);
        this.osc = new SineOscillator[this.amps.length];
        this.multipliers = new Multiply[this.ratios.length];
        int i = 0;
        while (i < this.osc.length) {
            this.osc[i] = new SineOscillator();
            this.synth.add(this.osc[i]);
            this.multipliers[i] = new Multiply();
            this.synth.add(this.multipliers[i]);
            this.osc[i].output.connect(0, this.lineOut.input, 0);
            this.osc[i].output.connect(0, this.lineOut.input, 1);
            this.ramp.output.connect(this.multipliers[i].inputA);
            this.multipliers[i].output.connect(this.osc[i].frequency);
            this.multipliers[i].inputB.set(this.ratios[i]);
            this.osc[i].amplitude.set(this.amps[i]);
            ++i;
        }
        this.ramp.current.set(100.0);
        this.ramp.time.set(3.0);
        this.ramp.input.set(700.0);
        this.lineOut.start();
        System.out.println("You should now be hearing a sine wave. ---------");
        try {
            this.synth.sleepFor(4.0);
            this.ramp.input.set(100.0);
            this.synth.sleepFor(4.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Stop playing. -------------------");
        this.synth.stop();
    }

    public static void main(String[] args) {
        System.out.println("Java version = " + System.getProperty("java.version"));
        new PlayPartials().test();
    }
}

