/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.scope.AudioScope;
import com.jsyn.scope.AudioScopeProbe;
import com.jsyn.scope.DefaultWaveTraceModel;
import com.jsyn.scope.MultiChannelScopeProbeUnit;
import com.jsyn.scope.TriggerModel;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioScopeModel
implements Runnable {
    private static final int PRE_TRIGGER_SIZE = 32;
    private Synthesizer synthesisEngine;
    private ArrayList<AudioScopeProbe> probes = new ArrayList();
    private CopyOnWriteArrayList<ChangeListener> changeListeners = new CopyOnWriteArrayList();
    private MultiChannelScopeProbeUnit probeUnit;
    private double timeToArm;
    private double period = 0.2;
    private TriggerModel triggerModel;

    public AudioScopeModel(Synthesizer synth) {
        this.synthesisEngine = synth;
        this.triggerModel = new TriggerModel();
    }

    public AudioScopeProbe addProbe(UnitOutputPort output, int partIndex) {
        AudioScopeProbe probe = new AudioScopeProbe(this, output, partIndex);
        DefaultWaveTraceModel waveTraceModel = new DefaultWaveTraceModel(this, this.probes.size());
        probe.setWaveTraceModel(waveTraceModel);
        this.probes.add(probe);
        if (this.triggerModel.getSource() == null) {
            this.triggerModel.setSource(probe);
        }
        return probe;
    }

    public void start() {
        this.stop();
        this.probeUnit = new MultiChannelScopeProbeUnit(this.probes.size(), this.triggerModel);
        this.synthesisEngine.add(this.probeUnit);
        int i = 0;
        while (i < this.probes.size()) {
            AudioScopeProbe probe = this.probes.get(i);
            probe.getSource().connect(probe.getPartIndex(), this.probeUnit.input, i);
            ++i;
        }
        this.triggerModel.getSource().getSource().connect(this.triggerModel.getSource().getPartIndex(), this.probeUnit.trigger, 0);
        this.probeUnit.start();
        this.timeToArm = this.synthesisEngine.getCurrentTime();
        this.probeUnit.arm(this.timeToArm, this);
    }

    public void stop() {
        if (this.probeUnit != null) {
            int i = 0;
            while (i < this.probes.size()) {
                this.probeUnit.input.disconnectAll(i);
                ++i;
            }
            this.probeUnit.trigger.disconnectAll();
            this.probeUnit.stop();
            this.synthesisEngine.remove(this.probeUnit);
            this.probeUnit = null;
        }
    }

    public AudioScopeProbe[] getProbes() {
        return this.probes.toArray(new AudioScopeProbe[0]);
    }

    public Synthesizer getSynthesizer() {
        return this.synthesisEngine;
    }

    @Override
    public void run() {
        this.fireChangeListeners();
        this.timeToArm = this.synthesisEngine.getCurrentTime();
        this.timeToArm += this.period;
        this.probeUnit.arm(this.timeToArm, this);
    }

    private void fireChangeListeners() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void setTriggerMode(AudioScope.TriggerMode triggerMode) {
        this.triggerModel.getModeModel().setSelectedItem((Object)triggerMode);
    }

    public void setTriggerSource(AudioScopeProbe probe) {
        this.triggerModel.setSource(probe);
    }

    public double getSample(int bufferIndex, int i) {
        return this.probeUnit.getSample(bufferIndex, i);
    }

    public int getFramesPerBuffer() {
        return this.probeUnit.getFramesPerBuffer();
    }

    public int getFramesCaptured() {
        return this.probeUnit.getFramesCaptured();
    }

    public int getVisibleSize() {
        int size = 0;
        if (this.probeUnit != null && (size = this.probeUnit.getPostTriggerSize() + 32) > this.getFramesCaptured()) {
            size = this.getFramesCaptured();
        }
        return size;
    }

    public int getStartIndex() {
        return this.getFramesCaptured() - this.getVisibleSize();
    }

    public TriggerModel getTriggerModel() {
        return this.triggerModel;
    }
}

