/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceAllocator;
import junit.framework.TestCase;

public class TestVoiceAllocator
extends TestCase {
    VoiceAllocator allocator;
    int max = 4;
    private UnitVoice[] voices;

    protected void setUp() throws Exception {
        super.setUp();
        this.voices = new UnitVoice[this.max];
        int i = 0;
        while (i < this.max) {
            this.voices[i] = new SubtractiveSynthVoice();
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAllocation() {
        TestVoiceAllocator.assertEquals((String)"get max", (int)this.max, (int)this.allocator.getVoiceCount());
        int tag1 = 61;
        int tag2 = 62;
        int tag3 = 63;
        int tag4 = 64;
        int tag5 = 65;
        int tag6 = 66;
        UnitVoice voice1 = this.allocator.allocate(tag1);
        TestVoiceAllocator.assertTrue((String)"voice should be non-null", (voice1 != null ? 1 : 0) != 0);
        UnitVoice voice2 = this.allocator.allocate(tag2);
        TestVoiceAllocator.assertTrue((String)"voice should be non-null", (voice2 != null ? 1 : 0) != 0);
        TestVoiceAllocator.assertTrue((String)"new voice ", (voice2 != voice1 ? 1 : 0) != 0);
        UnitVoice voice = this.allocator.allocate(tag1);
        TestVoiceAllocator.assertTrue((String)"should be voice1 again ", (voice == voice1 ? 1 : 0) != 0);
        voice = this.allocator.allocate(tag2);
        TestVoiceAllocator.assertTrue((String)"should be voice2 again ", (voice == voice2 ? 1 : 0) != 0);
        UnitVoice voice3 = this.allocator.allocate(tag3);
        UnitVoice voice4 = this.allocator.allocate(tag4);
        UnitVoice voice5 = this.allocator.allocate(tag5);
        TestVoiceAllocator.assertTrue((String)"ran out so get voice1 as oldest", (voice5 == voice1 ? 1 : 0) != 0);
        voice = this.allocator.allocate(tag2);
        TestVoiceAllocator.assertTrue((String)"should be voice2 again ", (voice == voice2 ? 1 : 0) != 0);
        UnitVoice voice6 = this.allocator.allocate(tag6);
        TestVoiceAllocator.assertTrue((String)"ran out so get voice3 as oldest", (voice6 == voice3 ? 1 : 0) != 0);
    }

    public void testOff() {
        int tag1 = 61;
        int tag2 = 62;
        int tag3 = 63;
        int tag4 = 64;
        int tag5 = 65;
        int tag6 = 66;
        UnitVoice voice1 = this.allocator.allocate(tag1);
        UnitVoice voice2 = this.allocator.allocate(tag2);
        UnitVoice voice3 = this.allocator.allocate(tag3);
        UnitVoice voice4 = this.allocator.allocate(tag4);
        TestVoiceAllocator.assertTrue((String)"voice 3 should start on", (boolean)this.allocator.isOn(tag3));
        this.allocator.off(tag3);
        TestVoiceAllocator.assertEquals((String)"voice 3 should now be off", (boolean)false, (boolean)this.allocator.isOn(tag3));
        this.allocator.off(tag2);
        UnitVoice voice5 = this.allocator.allocate(tag5);
        TestVoiceAllocator.assertTrue((String)"should get voice3 cuz off first", (voice5 == voice3 ? 1 : 0) != 0);
        UnitVoice voice6 = this.allocator.allocate(tag6);
        TestVoiceAllocator.assertTrue((String)"should get voice2 cuz off second", (voice6 == voice2 ? 1 : 0) != 0);
        voice3 = this.allocator.allocate(tag3);
        TestVoiceAllocator.assertTrue((String)"should get voice1 cuz on first", (voice3 == voice1 ? 1 : 0) != 0);
        voice1 = this.allocator.allocate(tag1);
        TestVoiceAllocator.assertTrue((String)"should get voice4 cuz next up", (voice1 == voice4 ? 1 : 0) != 0);
    }
}

