/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.util.soundfile.ChunkHandler;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class IFFParser
extends FilterInputStream {
    private long numBytesRead = 0L;
    private long totalSize = 0L;
    private int fileId;
    static boolean debug = false;
    public static final int RIFF_ID = 1380533830;
    public static final int LIST_ID = 1279873876;
    public static final int FORM_ID = 1179603533;

    IFFParser(InputStream stream) {
        super(stream);
    }

    public long getFileSize() {
        return this.totalSize;
    }

    public long getOffset() {
        return this.numBytesRead;
    }

    @Override
    public int read() throws IOException {
        ++this.numBytesRead;
        return super.read();
    }

    @Override
    public int read(byte[] bar) throws IOException {
        return this.read(bar, 0, bar.length);
    }

    @Override
    public int read(byte[] bar, int off, int len) throws IOException {
        int cursor = off;
        int numLeft = len;
        while (numLeft > 0) {
            int numRead = super.read(bar, cursor, numLeft);
            if (numRead < 0) {
                return numRead;
            }
            cursor += numRead;
            this.numBytesRead += (long)numRead;
            numLeft -= numRead;
        }
        return cursor - off;
    }

    @Override
    public long skip(long numBytes) throws IOException {
        this.numBytesRead += numBytes;
        return super.skip(numBytes);
    }

    public int readIntBig() throws IOException {
        int result = this.read() & 0xFF;
        result = result << 8 | this.read() & 0xFF;
        result = result << 8 | this.read() & 0xFF;
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readIntBig() - EOF in middle of word at offset " + this.numBytesRead);
        }
        result = result << 8 | data & 0xFF;
        return result;
    }

    public int readIntLittle() throws IOException {
        int result = this.read() & 0xFF;
        result |= (this.read() & 0xFF) << 8;
        result |= (this.read() & 0xFF) << 16;
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readIntLittle() - EOF in middle of word at offset " + this.numBytesRead);
        }
        return result |= data << 24;
    }

    public short readShortBig() throws IOException {
        short result = (short)(this.read() << 8);
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readShortBig() - EOF in middle of word at offset " + this.numBytesRead);
        }
        result = (short)(result | data & 0xFF);
        return result;
    }

    public short readShortLittle() throws IOException {
        short result = (short)(this.read() & 0xFF);
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readShortLittle() - EOF in middle of word at offset " + this.numBytesRead);
        }
        result = (short)(result | data << 8);
        return result;
    }

    public int readUShortLittle() throws IOException {
        return this.readShortLittle() & 0xFFFF;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readChunkSize() throws IOException {
        if (this.isRIFF()) {
            return this.readIntLittle();
        }
        return this.readIntBig();
    }

    public static String IDToString(int ID) {
        byte[] bar = new byte[]{(byte)(ID >> 24), (byte)(ID >> 16), (byte)(ID >> 8), (byte)ID};
        return new String(bar);
    }

    public void parseAfterHead(ChunkHandler handler) throws IOException {
        int numBytes = this.readChunkSize();
        this.totalSize = numBytes + 8;
        this.parseChunk(handler, this.fileId, numBytes);
        if (debug) {
            System.out.println("parse() ------- end");
        }
    }

    void parseForm(ChunkHandler handler, int ID, int numBytes, int type) throws IOException {
        if (debug) {
            System.out.println("IFF: parseForm >>>>>>>>>>>>>>>>>> BEGIN");
        }
        while (numBytes > 8) {
            int ckid = this.readIntBig();
            int size = this.readChunkSize();
            numBytes -= 8;
            if (debug) {
                System.out.println("chunk( " + IFFParser.IDToString(ckid) + ", " + size + " )");
            }
            if (size < 0) {
                throw new IOException("Bad IFF chunk Size: " + IFFParser.IDToString(ckid) + " = 0x" + Integer.toHexString(ckid) + ", Size = " + size);
            }
            this.parseChunk(handler, ckid, size);
            if ((size & 1) == 1) {
                ++size;
            }
            numBytes -= size;
            if (!debug) continue;
            System.out.println("parseForm: numBytes left in form = " + numBytes);
        }
        if (debug) {
            System.out.println("IFF: parseForm <<<<<<<<<<<<<<<<<<<< END");
        }
        if (numBytes > 0) {
            System.out.println("IFF Parser detected " + numBytes + " bytes of garbage at end of FORM.");
            this.skip(numBytes);
        }
    }

    void parseChunk(ChunkHandler handler, int ckid, int numBytes) throws IOException {
        int numRead;
        long endOffset;
        long startOffset = this.getOffset();
        if (this.isForm(ckid)) {
            int type = this.readIntBig();
            if (debug) {
                System.out.println("parseChunk:    form = " + IFFParser.IDToString(ckid) + ", " + numBytes + ", " + IFFParser.IDToString(type));
            }
            handler.handleForm(this, ckid, numBytes - 4, type);
            endOffset = this.getOffset();
            numRead = (int)(endOffset - startOffset);
            if (numRead < numBytes) {
                this.parseForm(handler, ckid, numBytes - numRead, type);
            }
        } else {
            handler.handleChunk(this, ckid, numBytes);
        }
        endOffset = this.getOffset();
        numRead = (int)(endOffset - startOffset);
        if (debug) {
            System.out.println("parseChunk:    endOffset = " + endOffset);
            System.out.println("parseChunk:    numRead = " + numRead);
        }
        if ((numBytes & 1) == 1) {
            ++numBytes;
        }
        if (numRead < numBytes) {
            this.skip(numBytes - numRead);
        }
    }

    public void readHead() throws IOException {
        if (debug) {
            System.out.println("parse() ------- begin");
        }
        this.numBytesRead = 0L;
        this.fileId = this.readIntBig();
    }

    public boolean isRIFF() {
        return this.fileId == 1380533830;
    }

    public boolean isIFF() {
        return this.fileId == 1179603533;
    }

    public boolean isForm(int ckid) {
        if (this.isRIFF()) {
            switch (ckid) {
                case 1279873876: 
                case 1380533830: {
                    return true;
                }
            }
            return false;
        }
        switch (ckid) {
            case 1179603533: 
            case 1279873876: {
                return true;
            }
        }
        return false;
    }
}

