/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.LabelledCanvas;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;

public class TriangularOperatorCanvas
extends LabelledCanvas {
    Font font = new Font("Monospaced", 1, 14);

    public TriangularOperatorCanvas(String text) {
        super(text);
        this.setFont(this.font);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        g.setColor(this.getHighlighted() ? this.getForeground() : this.getBackground());
        Polygon poly = new Polygon();
        poly.addPoint(0, 0);
        poly.addPoint(width, height / 2);
        poly.addPoint(0, height);
        g.fillPolygon(poly);
        String txt = this.getText();
        if (txt != null) {
            FontRenderContext frc = g2.getFontRenderContext();
            int textHeight = (int)this.getFont().getStringBounds(txt, frc).getHeight();
            g.setColor(this.getHighlighted() ? this.getBackground() : this.getForeground());
            g.drawString(txt, 3, (height + textHeight) / 2);
        }
        g.setColor(this.getForeground());
        g.drawPolygon(poly);
    }
}

