/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.syntona.model.SyntonaCommand;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.PatchModule;
import com.syntona.plugin.Jack;
import com.syntona.plugin.SyntonaModule;

public class DisconnectJacksCommand
implements SyntonaCommand {
    private Jack mSource;
    private Jack mDestination;
    private String sourceJackName;
    private String sourceModuleName;
    private String destinationJackName;
    private String destinationModuleName;
    private PatchModule mPatchModule;

    public DisconnectJacksCommand(Jack source, Jack destination) {
        this.mSource = source;
        this.mDestination = destination;
        this.sourceJackName = source.getName();
        this.mPatchModule = source.getModule().getParent();
        this.sourceModuleName = source.getModule().getName();
        this.destinationJackName = destination.getName();
        this.destinationModuleName = destination.getModule().getName();
    }

    @Override
    public void execute() {
        this.mSource.disconnect(this.mDestination);
        SyntonaEngine.getInstance().pushUndoCommand(this);
        this.mSource = null;
        this.mDestination = null;
    }

    @Override
    public void undo() {
        SyntonaModule sourceModule = this.mPatchModule.findModuleByName(this.sourceModuleName);
        if (sourceModule == null) {
            System.err.println("Module " + this.sourceModuleName + " not found.");
            return;
        }
        Jack sourceJack = sourceModule.getJackByName(this.sourceJackName);
        if (sourceJack == null) {
            System.err.println("Jack " + this.sourceJackName + " not found.");
            return;
        }
        SyntonaModule destinationModule = this.mPatchModule.findModuleByName(this.destinationModuleName);
        if (destinationModule == null) {
            System.err.println("Module " + this.destinationModuleName + " not found.");
            return;
        }
        Jack destinationJack = destinationModule.getJackByName(this.destinationJackName);
        if (destinationJack == null) {
            System.err.println("Jack " + this.destinationJackName + " not found.");
            return;
        }
        sourceJack.connect(destinationJack);
        sourceModule.getParent().firePatchChanged();
    }

    public String toString() {
        return "disconnect " + this.sourceJackName + " from " + this.destinationJackName;
    }
}

