/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.unitgen.UnitGate;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.jsyn.JSynExportableModule;

public class UnitGenModule
extends JSynExportableModule {
    protected UnitGenerator ugen;

    public UnitGenModule() {
    }

    public void setup(UnitGenerator sound) {
        this.ugen = sound;
    }

    public UnitGenModule(String help) {
        super(help);
    }

    public UnitGenerator getSound() {
        return this.ugen;
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 0: {
                exporter.addClass(this.getExportedClass());
                break;
            }
            case 2: {
                writer.println(String.valueOf(this.getExportedClassName()) + " " + this.getExportedObjectName() + ";");
                break;
            }
            case 4: {
                writer.println("add(" + this.getExportedObjectName() + " = new " + this.getExportedClassName() + "(" + this.exportConstructorArguments() + "));");
                break;
            }
            case 8: {
                if (!(this.getSound() instanceof UnitGate)) break;
                writer.println(String.valueOf(this.getExportedObjectName()) + ".input.on(timeStamp);");
                break;
            }
            case 9: {
                if (!(this.getSound() instanceof UnitGate)) break;
                writer.println(String.valueOf(this.getExportedObjectName()) + ".input.off(timeStamp);");
            }
        }
    }

    public String exportConstructorArguments() {
        return "";
    }

    @Override
    public Class getExportedClass() {
        return this.ugen.getClass();
    }

    String getTagName() {
        return "unit";
    }

    @Override
    public void noteOn(double frequency, double amplitude) {
        super.noteOn(frequency, amplitude);
        if (this.getSound() instanceof UnitGate) {
            UnitGate unitGate = (UnitGate)this.getSound();
            if (!unitGate.input.isConnected()) {
                unitGate.input.on();
            }
        }
    }

    @Override
    public void noteOff() {
        if (this.getSound() instanceof UnitGate) {
            UnitGate unitGate = (UnitGate)this.getSound();
            if (!unitGate.input.isConnected()) {
                unitGate.input.off();
            }
        }
        super.noteOff();
    }
}

