/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.jsyn.util.NumericOutput;
import com.syntona.plugin.DoubleRangeModel;
import com.syntona.plugin.JTextFieldDirty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTextFieldDouble
extends JTextFieldDirty {
    DoubleRangeModel mModel = null;

    public JTextFieldDouble(DoubleRangeModel model, int numCharacters) {
        super(numCharacters);
        this.mModel = model;
        this.updateTextFromModel();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    double val = JTextFieldDouble.this.getValue();
                    JTextFieldDouble.this.mModel.setValue(val);
                }
                catch (NumberFormatException e) {
                    JTextFieldDouble.this.setText("Error!");
                    JTextFieldDouble.this.selectAll();
                }
            }
        });
        this.mModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTextFieldDouble.this.updateTextFromModel();
            }
        });
    }

    public JTextFieldDouble(double value, int numCharacters) {
        super(numCharacters);
        this.setValue(value);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JTextFieldDouble.this.getValue();
                }
                catch (NumberFormatException e) {
                    JTextFieldDouble.this.setText("Error!");
                    JTextFieldDouble.this.selectAll();
                }
            }
        });
    }

    public double getValue() throws NumberFormatException {
        String text = this.getText();
        if (text == null) {
            NumberFormatException e = new NumberFormatException("getText() returned null");
            throw e;
        }
        return Double.valueOf(text);
    }

    private void updateTextFromModel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextFieldDouble.this.setText(NumericOutput.doubleToString(JTextFieldDouble.this.mModel.getValue(), 1, 4));
                JTextFieldDouble.this.markClean();
            }
        });
    }

    public void setValue(final double value) {
        if (this.mModel != null) {
            this.mModel.setValue(value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTextFieldDouble.this.setText(NumericOutput.doubleToString(value, 1, 4));
                    JTextFieldDouble.this.markClean();
                }
            });
        }
    }
}

