/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.apps;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.javasound.MidiDeviceTools;
import com.jsyn.instruments.JSynInstrumentLibrary;
import com.jsyn.midi.MessageParser;
import com.jsyn.swing.InstrumentBrowser;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PresetSelectionListener;
import com.jsyn.swing.SoundTweaker;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.PolyphonicInstrument;
import com.jsyn.util.VoiceDescription;
import com.softsynth.math.AudioMath;
import com.softsynth.shared.time.TimeStamp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.swing.JApplet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentTester
extends JApplet {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentTester.class);
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private LineOut lineOut;
    private SoundTweaker tweaker;
    protected PolyphonicInstrument instrument;
    private MyParser messageParser;

    public int setupMidiKeyboard() throws MidiUnavailableException, IOException, InterruptedException {
        this.messageParser = new MyParser();
        int result = 2;
        MidiDevice keyboard = MidiDeviceTools.findKeyboard();
        CustomReceiver receiver = new CustomReceiver();
        if (keyboard != null) {
            keyboard.open();
            keyboard.getTransmitter().setReceiver(receiver);
            LOGGER.debug("Play MIDI keyboard: " + keyboard.getDeviceInfo().getDescription());
            result = 0;
        } else {
            LOGGER.debug("Could not find a keyboard.");
        }
        return result;
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        InstrumentBrowser browser = new InstrumentBrowser(new JSynInstrumentLibrary());
        browser.addPresetSelectionListener(new PresetSelectionListener(){

            @Override
            public void presetSelected(VoiceDescription voiceDescription, int presetIndex) {
                UnitVoice[] voices = new UnitVoice[8];
                int i = 0;
                while (i < voices.length) {
                    voices[i] = voiceDescription.createUnitVoice();
                    ++i;
                }
                InstrumentTester.this.instrument = new PolyphonicInstrument(voices);
                InstrumentTester.this.synth.add(InstrumentTester.this.instrument);
                InstrumentTester.this.instrument.usePreset(presetIndex, InstrumentTester.this.synth.createTimeStamp());
                String title = String.valueOf(voiceDescription.getVoiceClassName()) + ": " + voiceDescription.getPresetNames()[presetIndex];
                InstrumentTester.this.useSource(InstrumentTester.this.instrument, title);
            }
        });
        this.add((Component)browser, "North");
        try {
            this.setupMidiKeyboard();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.validate();
    }

    private void useSource(UnitSource voice, String title) {
        this.lineOut.input.disconnectAll(0);
        this.lineOut.input.disconnectAll(1);
        voice.getOutput().connect(0, this.lineOut.input, 0);
        voice.getOutput().connect(0, this.lineOut.input, 1);
        if (this.tweaker != null) {
            this.remove(this.tweaker);
        }
        try {
            if (this.synth.isRunning()) {
                this.synth.sleepFor(0.1);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.tweaker = new SoundTweaker(this.synth, title, voice);
        this.add((Component)this.tweaker, "Center");
        this.validate();
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] args) {
        InstrumentTester applet = new InstrumentTester();
        JAppletFrame frame = new JAppletFrame("InstrumentTester", applet);
        frame.setSize(600, 800);
        frame.setVisible(true);
        frame.test();
    }

    class CustomReceiver
    implements Receiver {
        CustomReceiver() {
        }

        @Override
        public void close() {
            System.out.print("Closed.");
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            byte[] bytes = message.getMessage();
            InstrumentTester.this.messageParser.parse(bytes);
        }
    }

    class MyParser
    extends MessageParser {
        MyParser() {
        }

        @Override
        public void controlChange(int channel, int index, int value) {
        }

        @Override
        public void noteOff(int channel, int noteNumber, int velocity) {
            InstrumentTester.this.instrument.noteOff(noteNumber, InstrumentTester.this.synth.createTimeStamp());
        }

        @Override
        public void noteOn(int channel, int noteNumber, int velocity) {
            double frequency = AudioMath.pitchToFrequency(noteNumber);
            double amplitude = (double)velocity / 512.0;
            TimeStamp timeStamp = InstrumentTester.this.synth.createTimeStamp();
            InstrumentTester.this.instrument.noteOn(noteNumber, frequency, amplitude, timeStamp);
        }
    }
}

