/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices;

import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.util.JavaTools;

public class AudioDeviceFactory {
    private static AudioDeviceManager instance;

    public static void setInstance(AudioDeviceManager instance) {
        AudioDeviceFactory.instance = instance;
    }

    public static AudioDeviceManager createAudioDeviceManager() {
        return AudioDeviceFactory.createAudioDeviceManager(false);
    }

    public static AudioDeviceManager createAudioDeviceManager(boolean preferJavaSound) {
        if (preferJavaSound) {
            AudioDeviceFactory.tryJavaSound();
            AudioDeviceFactory.tryJPortAudio();
        } else {
            AudioDeviceFactory.tryJPortAudio();
            AudioDeviceFactory.tryJavaSound();
        }
        return instance;
    }

    private static void tryJavaSound() {
        if (instance == null) {
            try {
                Class clazz = JavaTools.loadClass("com.jsyn.devices.javasound.JavaSoundAudioDevice", false);
                if (clazz != null) {
                    instance = (AudioDeviceManager)clazz.newInstance();
                }
            }
            catch (Throwable e) {
                System.err.println("Could not load JavaSound device. " + e);
            }
        }
    }

    private static void tryJPortAudio() {
        if (instance == null) {
            try {
                if (JavaTools.loadClass("com.portaudio.PortAudio", false) != null) {
                    instance = (AudioDeviceManager)JavaTools.loadClass("com.jsyn.devices.jportaudio.JPortAudioDevice").newInstance();
                } else {
                    System.err.println("Could not load com.portaudio.PortAudio ");
                }
            }
            catch (Throwable e) {
                System.err.println("Could not load JPortAudio device. " + e);
            }
        }
    }
}

